/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.bouncycastle.util.Arrays;
import org.openecard.mdlw.sal.AttributeUtils;
import org.openecard.mdlw.sal.CertCategory;
import org.openecard.mdlw.sal.MiddleWareWrapper;
import org.openecard.mdlw.sal.MwSession;
import org.openecard.mdlw.sal.cryptoki.CK_DATE;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.openecard.mdlw.sal.struct.CkAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MwCertificate {
    private static final Logger LOG = LoggerFactory.getLogger(MwCertificate.class);
    private final long objectHandle;
    private final MiddleWareWrapper mw;
    private final MwSession session;
    private final byte[] value;
    private final String label;
    private final byte[] id;
    private final byte[] subject;
    private final byte[] issuer;
    private final long certType;
    private final Boolean trusted;
    private final long certCategory;
    private final byte[] checkValue;
    private final Calendar startDate;
    private final Calendar endDate;

    public MwCertificate(long objectHandle, MiddleWareWrapper mw, MwSession mwSession) throws CryptokiException {
        this.objectHandle = objectHandle;
        this.mw = mw;
        this.session = mwSession;
        this.value = this.loadAttrValValue();
        this.label = this.loadAttrValLabel();
        this.id = this.loadAttrValID();
        this.subject = this.loadByteArray(257);
        this.issuer = this.loadByteArray(129);
        this.certType = this.loadAttrValCertificateType();
        this.trusted = this.loadAttrValTrusted();
        this.certCategory = this.loadAttrValCertificateCategory();
        this.checkValue = this.loadAttrValCheckValue();
        this.startDate = this.loadAttrValStartDate();
        this.endDate = this.loadAttrValEndDate();
    }

    @Nullable
    private CkAttribute getAttributeChecked(int type) throws CryptokiException {
        try {
            return this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, type);
        }
        catch (CryptokiException ex) {
            switch ((int)ex.getErrorCode()) {
                case 18: {
                    LOG.debug("Error retrieving attribute value, but ignoring it.", ex);
                    return null;
                }
            }
            throw ex;
        }
    }

    private byte[] loadByteArray(int type) throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, type);
        return AttributeUtils.getBytes(raw);
    }

    private byte[] loadAttrValValue() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 17L);
        return AttributeUtils.getBytes(raw);
    }

    private String loadAttrValLabel() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 3L);
        return AttributeUtils.getString(raw);
    }

    private byte[] loadAttrValID() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 258L);
        return AttributeUtils.getBytes(raw);
    }

    private long loadAttrValCertificateType() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 128L);
        return AttributeUtils.getLong(raw);
    }

    private Boolean loadAttrValTrusted() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 134L);
        return AttributeUtils.getBool(raw);
    }

    private long loadAttrValCertificateCategory() throws CryptokiException {
        CkAttribute raw = this.getAttributeChecked(135);
        return raw != null ? AttributeUtils.getLong(raw) : 0L;
    }

    private byte[] loadAttrValCheckValue() throws CryptokiException {
        CkAttribute raw = this.getAttributeChecked(144);
        return raw != null ? AttributeUtils.getBytes(raw) : null;
    }

    private Calendar loadAttrValStartDate() throws CryptokiException {
        int dataLen;
        CkAttribute raw = this.getAttributeChecked(272);
        int n = dataLen = raw != null ? raw.getLength().intValue() : 0;
        if (dataLen > 0) {
            assert (raw != null);
            CK_DATE d = new CK_DATE(raw.getData());
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            cal.set(Integer.parseInt(new String(d.getYear())), Integer.parseInt(new String(d.getMonth())) - 1, Integer.parseInt(new String(d.getDay())));
            return cal;
        }
        return null;
    }

    private Calendar loadAttrValEndDate() throws CryptokiException {
        int dataLen;
        CkAttribute raw = this.getAttributeChecked(273);
        int n = dataLen = raw != null ? raw.getLength().intValue() : 0;
        if (dataLen > 0) {
            assert (raw != null);
            CK_DATE d = new CK_DATE(raw.getData());
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            cal.set(Integer.parseInt(new String(d.getYear())), Integer.parseInt(new String(d.getMonth())) - 1, Integer.parseInt(new String(d.getDay())));
            return cal;
        }
        return null;
    }

    public long getObjectHandle() {
        return this.objectHandle;
    }

    public MiddleWareWrapper getMW() {
        return this.mw;
    }

    public MwSession getSession() {
        return this.session;
    }

    public String getLabel() {
        return this.label;
    }

    public byte[] getID() {
        return this.id;
    }

    public byte[] getSubject() {
        return this.subject;
    }

    public byte[] getIssuer() {
        return this.issuer;
    }

    public String getCertificateType() {
        switch ((int)this.certType) {
            case 0: {
                return "CKC_X_509";
            }
            case 1: {
                return "CKC_X_509_ATTR_CERT";
            }
            case 2: {
                return "CKC_WTLS";
            }
            case -2147483648: {
                return "CKC_VENDOR_DEFINED";
            }
        }
        return "UNKNOWN";
    }

    public Boolean getTrusted() {
        return this.trusted;
    }

    public CertCategory getCertificateCategory() {
        return CertCategory.forCategoryType(this.certCategory);
    }

    @Nullable
    public byte[] getCheckValue() {
        return this.checkValue;
    }

    @Nullable
    public Calendar getStartDate() {
        return this.startDate;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    @Nonnull
    public byte[] getValue() {
        return Arrays.clone(this.value);
    }
}

