/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.event;

import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.util.Iterator;
import java.util.List;
import org.openecard.common.event.EventObject;
import org.openecard.common.event.EventType;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.interfaces.EventCallback;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.mdlw.event.MwEventObject;
import org.openecard.mdlw.sal.MwSlot;
import org.openecard.mdlw.sal.MwToken;
import org.openecard.mdlw.sal.config.MiddlewareConfig;
import org.openecard.mdlw.sal.config.MiddlewareConfigLoader;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MwStateCallback
implements EventCallback {
    private static final Logger LOG = LoggerFactory.getLogger(MwStateCallback.class);
    private final Environment env;
    private final CardStateMap states;
    private final List<MiddlewareConfig> mwConfigs;

    public MwStateCallback(Environment env, CardStateMap cardState, MiddlewareConfigLoader mwConfigLoader) {
        this.env = env;
        this.states = cardState;
        this.mwConfigs = mwConfigLoader.getMiddlewareConfigs();
    }

    @Override
    public void signalEvent(EventType eventType, EventObject o) {
        try {
            if (o instanceof MwEventObject) {
                ConnectionHandleType handle = ((MwEventObject)o).getHandle();
                MwSlot slot = ((MwEventObject)o).getMwSlot();
                switch (eventType) {
                    case CARD_RECOGNIZED: {
                        MiddlewareConfig mwConfig;
                        MwToken token = slot.getTokenInfo();
                        String cardType = null;
                        String type = String.format("%s_%s", token.getManufacturerID(), token.getModel());
                        Iterator<MiddlewareConfig> iterator = this.mwConfigs.iterator();
                        while (iterator.hasNext() && (cardType = (mwConfig = iterator.next()).mapMiddlewareType(type)) == null) {
                        }
                        CardInfoType cif = null;
                        if (cardType != null) {
                            cif = this.env.getCIFProvider().getCardInfo(handle, cardType);
                        }
                        if (cif == null) {
                            LOG.warn("Unknown card recognized by Middleware.");
                            return;
                        }
                        CardStateEntry entry = new CardStateEntry(handle, cif, null);
                        this.states.addEntry(entry);
                        break;
                    }
                    case CARD_REMOVED: {
                        LOG.info("Remove card");
                        this.states.removeEntry(handle);
                        break;
                    }
                    default: {
                        LOG.debug("No relevant event received.");
                    }
                }
            }
        }
        catch (CryptokiException ex) {
            LOG.info("Cryptoki Token invalid.", ex);
        }
        catch (RuntimeException ex) {
            LOG.error("Error in CIF augmentation process.", ex);
        }
    }
}

