/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.event;

import java.util.concurrent.FutureTask;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.util.HandlerBuilder;
import org.openecard.common.util.ValueGenerators;
import org.openecard.mdlw.event.MwEventRunner;
import org.openecard.mdlw.sal.MiddlewareSAL;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.openecard.mdlw.sal.exceptions.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MwEventManager {
    private static final Logger LOG = LoggerFactory.getLogger(MwEventManager.class);
    private final MiddlewareSAL mwSAL;
    private final Environment env;
    private final String sessionId;
    private final HandlerBuilder builder;
    private FutureTask<Void> watcher;

    public MwEventManager(Environment env, MiddlewareSAL mwSAL, byte[] contextHandle) {
        this.env = env;
        this.mwSAL = mwSAL;
        this.sessionId = ValueGenerators.genBase64Session();
        this.builder = HandlerBuilder.create().setContextHandle(contextHandle).setSessionId(this.sessionId);
    }

    public void initialize() throws InitializationException {
        try {
            DatatypeFactory dataFactory = DatatypeFactory.newInstance();
            MwEventRunner runner = new MwEventRunner(this.env, this.builder, dataFactory, this.mwSAL.getMwModule());
            runner.initRunner();
            this.watcher = new FutureTask<Object>(runner, null);
            Thread t = new Thread(this.watcher, "MwEventManager");
            t.start();
        }
        catch (CryptokiException ex) {
            LOG.error("Failed to initialize middleware event runner.", ex);
            throw new InitializationException("Failed to request initial status from middleware.", ex.getErrorCode());
        }
        catch (DatatypeConfigurationException ex) {
            throw new UnsupportedOperationException("Datatype factory not supported.", ex);
        }
    }

    public void terminate() {
        this.watcher.cancel(true);
    }
}

