/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio.wrapper;

import iso.std.iso_iec._24727.tech.schema.BioSensorCapabilityType;
import iso.std.iso_iec._24727.tech.schema.DisplayCapabilityType;
import iso.std.iso_iec._24727.tech.schema.IFDStatusType;
import iso.std.iso_iec._24727.tech.schema.KeyPadCapabilityType;
import iso.std.iso_iec._24727.tech.schema.SlotCapabilityType;
import iso.std.iso_iec._24727.tech.schema.SlotStatusType;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.common.ifd.PACECapabilities;
import org.openecard.common.ifd.scio.SCIOATR;
import org.openecard.common.ifd.scio.SCIOErrorCode;
import org.openecard.common.ifd.scio.SCIOException;
import org.openecard.common.ifd.scio.SCIOTerminal;
import org.openecard.common.util.ByteUtils;
import org.openecard.ifd.scio.reader.ExecutePACERequest;
import org.openecard.ifd.scio.reader.ExecutePACEResponse;
import org.openecard.ifd.scio.reader.PCSCFeatures;
import org.openecard.ifd.scio.wrapper.ChannelManager;
import org.openecard.ifd.scio.wrapper.SingleThreadChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalInfo {
    private static final Logger LOG = LoggerFactory.getLogger(TerminalInfo.class);
    private final ChannelManager cm;
    private final SCIOTerminal term;
    private final boolean externalChannel;
    private SingleThreadChannel channel = null;
    private Map<Integer, Integer> featureCodes;
    private Boolean acoustic = null;
    private Boolean optic = null;
    private boolean slotCapRead = false;
    private SlotCapabilityType slotCap = null;
    private boolean dispCapRead = false;
    private DisplayCapabilityType dispCap = null;
    private boolean keyCapRead = false;
    private KeyPadCapabilityType keyCap = null;
    private boolean bioCapRead = false;
    private BioSensorCapabilityType bioCap = null;
    private List<PACECapabilities.PACECapability> PACECapabilities = null;

    public TerminalInfo(ChannelManager cm, SCIOTerminal term) {
        this.cm = cm;
        this.term = term;
        this.externalChannel = false;
    }

    public TerminalInfo(ChannelManager cm, SingleThreadChannel channel) {
        this.cm = cm;
        this.term = channel.getChannel().getCard().getTerminal();
        this.externalChannel = true;
        this.channel = channel;
    }

    public String getName() {
        return this.term.getName();
    }

    public boolean isCardPresent() {
        try {
            return this.term.isCardPresent();
        }
        catch (SCIOException ex) {
            return false;
        }
    }

    public boolean isConnected() {
        return this.channel != null;
    }

    @Nonnull
    public IFDStatusType getStatus() throws SCIOException {
        IFDStatusType status = new IFDStatusType();
        status.setIFDName(this.getName());
        status.setConnected(true);
        SlotStatusType stype = new SlotStatusType();
        status.getSlotStatus().add(stype);
        boolean cardPresent = this.isCardPresent();
        stype.setCardAvailable(cardPresent);
        stype.setIndex(BigInteger.ZERO);
        if (this.isConnected()) {
            SCIOATR atr = this.channel.getChannel().getCard().getATR();
            stype.setATRorATS(atr.getBytes());
        } else if (cardPresent) {
            SingleThreadChannel ch = new SingleThreadChannel(this.term, true);
            SCIOATR atr = ch.getChannel().getCard().getATR();
            stype.setATRorATS(atr.getBytes());
            ch.shutdown();
        }
        return status;
    }

    public SlotCapabilityType getSlotCapability() throws SCIOException {
        if (!this.slotCapRead) {
            SlotCapabilityType cap = new SlotCapabilityType();
            cap.setIndex(BigInteger.ZERO);
            if (this.supportsPace()) {
                List<PACECapabilities.PACECapability> capabilities = this.getPACECapabilities();
                List<String> protos = TerminalInfo.buildPACEProtocolList(capabilities);
                cap.getProtocol().addAll(protos);
            }
            if (this.supportsPinCompare()) {
                cap.getProtocol().add("urn:oid:1.3.162.15480.3.0.9");
            }
            this.slotCap = cap;
            this.slotCapRead = true;
        }
        return this.slotCap;
    }

    public static List<String> buildPACEProtocolList(List<PACECapabilities.PACECapability> paceCapabilities) {
        LinkedList<String> supportedProtos = new LinkedList<String>();
        for (PACECapabilities.PACECapability next : paceCapabilities) {
            supportedProtos.add(next.getProtocol());
        }
        return supportedProtos;
    }

    public boolean isAcousticSignal() throws SCIOException {
        if (this.acoustic == null) {
            this.acoustic = false;
        }
        return this.acoustic;
    }

    public boolean isOpticalSignal() throws SCIOException {
        if (this.optic == null) {
            this.optic = false;
        }
        return this.optic;
    }

    @Nullable
    public DisplayCapabilityType getDisplayCapability() throws SCIOException {
        if (!this.dispCapRead && this.isConnected()) {
            Integer displayFeature;
            byte[] data;
            Map<Integer, Integer> features = this.getFeatureCodes();
            if (features.containsKey(17) && (data = this.channel.transmitControlCommand(displayFeature = features.get(17), new byte[0])).length == 4) {
                int lineLength = ByteUtils.toInteger(Arrays.copyOfRange(data, 0, 2));
                int numLines = ByteUtils.toInteger(Arrays.copyOfRange(data, 2, 4));
                if (lineLength > 0 && numLines > 0) {
                    this.dispCap = new DisplayCapabilityType();
                    this.dispCap.setIndex(BigInteger.ZERO);
                    this.dispCap.setColumns(BigInteger.valueOf(lineLength));
                    this.dispCap.setLines(BigInteger.valueOf(numLines));
                }
            }
            this.dispCapRead = true;
        }
        return this.dispCap;
    }

    @Nullable
    public KeyPadCapabilityType getKeypadCapability() throws SCIOException {
        if (!this.keyCapRead && this.isConnected()) {
            Integer pinFeature;
            byte[] data;
            Map<Integer, Integer> features = this.getFeatureCodes();
            if (features.containsKey(10) && (data = this.channel.transmitControlCommand(pinFeature = features.get(10), new byte[0])).length == 4) {
                int wcdLayout = ByteUtils.toInteger(Arrays.copyOfRange(data, 0, 2));
                byte entryValidation = data[2];
                byte timeOut2 = data[3];
                this.keyCap = new KeyPadCapabilityType();
                this.keyCap.setIndex(BigInteger.ZERO);
                this.keyCap.setKeys(BigInteger.valueOf(16L));
            }
            this.keyCapRead = true;
        }
        return this.keyCap;
    }

    @Nullable
    public BioSensorCapabilityType getBiosensorCapability() {
        if (!this.bioCapRead) {
            this.bioCap = null;
            this.bioCapRead = true;
        }
        return this.bioCap;
    }

    private Integer getPaceCtrlCode() throws SCIOException {
        if (this.isConnected()) {
            Map<Integer, Integer> features = this.getFeatureCodes();
            return features.get(32);
        }
        return null;
    }

    public boolean supportsPace() throws SCIOException {
        return this.getPaceCtrlCode() != null;
    }

    public List<PACECapabilities.PACECapability> getPACECapabilities() throws SCIOException {
        LinkedList<PACECapabilities.PACECapability> result = new LinkedList<PACECapabilities.PACECapability>();
        if (this.PACECapabilities == null) {
            if (this.isConnected() && this.supportsPace()) {
                ExecutePACERequest.Function paceFunc;
                byte[] getCapabilityRequest;
                int ctrlCode = this.getPaceCtrlCode();
                byte[] response = this.channel.transmitControlCommand(ctrlCode, getCapabilityRequest = new ExecutePACERequest(paceFunc = ExecutePACERequest.Function.GetReaderPACECapabilities).toBytes());
                ExecutePACEResponse paceResponse = new ExecutePACEResponse(response);
                if (paceResponse.isError()) {
                    String msg = "PACE is advertised but the result iss errornous.\n";
                    msg = msg + paceResponse.getResult().getResultMessage().getValue();
                    throw new SCIOException(msg, SCIOErrorCode.SCARD_F_UNKNOWN_ERROR);
                }
                PACECapabilities cap = new PACECapabilities(paceResponse.getData());
                this.PACECapabilities = cap.getFeaturesEnum();
                result.addAll(this.PACECapabilities);
            }
        } else {
            result.addAll(this.PACECapabilities);
        }
        return Collections.unmodifiableList(result);
    }

    private Integer getPinCompareCtrlCode() throws SCIOException {
        if (this.isConnected()) {
            Map<Integer, Integer> features = this.getFeatureCodes();
            return features.get(6);
        }
        return null;
    }

    public boolean supportsPinCompare() throws SCIOException {
        return this.getPinCompareCtrlCode() != null;
    }

    @Nonnull
    public Map<Integer, Integer> getFeatureCodes() throws SCIOException {
        if (this.isConnected()) {
            if (this.featureCodes == null) {
                int code = PCSCFeatures.GET_FEATURE_REQUEST_CTLCODE();
                try {
                    byte[] response = this.channel.transmitControlCommand(code, new byte[0]);
                    this.featureCodes = PCSCFeatures.featureMapFromRequest(response);
                }
                catch (SCIOException ex) {
                    LOG.warn("Unable to request features from reader.", ex);
                    this.featureCodes = new HashMap<Integer, Integer>();
                }
                catch (IllegalStateException ex) {
                    LOG.warn("Transmit control command failed due to missing card connection.", ex);
                    return Collections.emptyMap();
                }
            }
            return this.featureCodes;
        }
        return Collections.emptyMap();
    }
}

