/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio.reader;

import java.io.ByteArrayOutputStream;
import org.openecard.common.util.ShortUtils;

public class ExecutePACERequest {
    private Function function;
    private short dataLength = 0;
    private byte[] data;

    public ExecutePACERequest(Function f) {
        this.function = f;
    }

    public ExecutePACERequest(Function f, byte[] data) {
        this.function = f;
        this.dataLength = (short)data.length;
        this.data = data;
    }

    public byte[] toBytes() {
        int i;
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        o.write(this.function.getCode());
        byte[] dataLength_bytes = ShortUtils.toByteArray(this.dataLength);
        for (i = dataLength_bytes.length - 1; i >= 0; --i) {
            o.write(dataLength_bytes[i]);
        }
        for (i = dataLength_bytes.length; i < 2; ++i) {
            o.write(0);
        }
        if (this.dataLength > 0) {
            o.write(this.data, 0, this.data.length);
        }
        return o.toByteArray();
    }

    public static enum Function {
        GetReaderPACECapabilities(1),
        EstablishPACEChannel(2),
        DestroyPACEChannel(3);

        private byte code;

        private Function(byte code) {
            this.code = code;
        }

        private byte getCode() {
            return this.code;
        }
    }
}

