/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.protocol.pace;

import java.security.GeneralSecurityException;
import java.util.List;
import org.openecard.common.apdu.GeneralAuthenticate;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.apdu.exception.APDUException;
import org.openecard.common.ifd.protocol.exception.ProtocolException;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.asn1.eac.PACEDomainParameter;
import org.openecard.crypto.common.asn1.eac.PACESecurityInfoPair;
import org.openecard.crypto.common.asn1.eac.PACESecurityInfos;
import org.openecard.crypto.common.asn1.utils.ObjectIdentifierUtils;
import org.openecard.ifd.protocol.pace.PACEConstants;
import org.openecard.ifd.protocol.pace.apdu.MSESetATPACE;
import org.openecard.ifd.protocol.pace.crypto.AuthenticationToken;
import org.openecard.ifd.protocol.pace.crypto.KDF;
import org.openecard.ifd.protocol.pace.crypto.PACECryptoSuite;
import org.openecard.ifd.protocol.pace.crypto.PACEGenericMapping;
import org.openecard.ifd.protocol.pace.crypto.PACEIntegratedMapping;
import org.openecard.ifd.protocol.pace.crypto.PACEKey;
import org.openecard.ifd.protocol.pace.crypto.PACEMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PACEImplementation {
    private static final Logger logger = LoggerFactory.getLogger(PACEImplementation.class);
    private final Dispatcher dispatcher;
    private final KDF kdf;
    private final byte[] slotHandle;
    private CardResponseAPDU response;
    private final PACESecurityInfoPair psip;
    private final PACECryptoSuite cryptoSuite;
    private PACEDomainParameter domainParameter;
    private PACEKey keyPCD;
    private PACEKey keyPICC;
    private byte[] keyMAC;
    private byte[] keyENC;
    private byte[] password;
    private byte[] s;
    private byte[] currentCAR;
    private byte[] previousCAR;
    private byte retryCounter = (byte)3;
    private boolean specifiedCHAT;

    public PACEImplementation(Dispatcher dispatcher, byte[] slotHandle, PACESecurityInfos paceSecurityInfos) throws Exception {
        this.dispatcher = dispatcher;
        this.slotHandle = slotHandle;
        List<PACESecurityInfoPair> paceInfoPairs = paceSecurityInfos.getPACEInfoPairs(PACEConstants.SUPPORTED_PACE_PROTOCOLS, PACEConstants.SUPPORTED_PACE_DOMAIN_PARAMS);
        if (paceInfoPairs.isEmpty()) {
            String msg = "No supported PACE keys found on the card.";
            logger.error(msg);
            throw new ProtocolException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#inappropriateProtocolForAction", msg);
        }
        this.psip = paceInfoPairs.get(0);
        this.domainParameter = new PACEDomainParameter(this.psip);
        this.cryptoSuite = new PACECryptoSuite(this.psip.getPACEInfo(), this.domainParameter);
        this.kdf = new KDF();
    }

    public void execute(byte[] password, byte passwordID, byte[] chat) throws Exception {
        this.password = password;
        this.specifiedCHAT = chat != null;
        this.mseSetAT(passwordID, chat);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mseSetAT(byte passwordID, byte[] chat) throws Exception {
        byte[] oID = ObjectIdentifierUtils.getValue(this.psip.getPACEInfo().getProtocol());
        MSESetATPACE mseSetAT = new MSESetATPACE(oID, passwordID, this.psip.getPACEInfo().getParameterID(), chat);
        try {
            this.response = mseSetAT.transmit(this.dispatcher, this.slotHandle);
            this.generalAuthenticateEncryptedNonce();
            return;
        }
        catch (APDUException e) {
            logger.error(e.getMessage(), e);
            short sw = e.getResponseAPDU().getSW();
            if (sw == 25219) {
                throw new ProtocolException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordDeactivated");
            }
            if ((sw & 0xFFFFFFF0) != 25536) return;
            this.retryCounter = (byte)(sw & 0xF);
            if (this.retryCounter == 0) {
                logger.warn("The password is blocked. The password MUST be unblocked.");
                if (passwordID != 4) throw new ProtocolException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordBlocked", "The password is blocked. The password MUST be unblocked.");
                this.generalAuthenticateEncryptedNonce();
                return;
            } else if (this.retryCounter == 1) {
                logger.warn("The password is suspended. The password MUST be resumed.");
                this.generalAuthenticateEncryptedNonce();
                return;
            } else {
                if (this.retryCounter != 2) return;
                logger.warn("The password is wrong.");
                this.generalAuthenticateEncryptedNonce();
            }
            return;
        }
        catch (ProtocolException e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new ProtocolException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/unknownError", e.getMessage());
        }
    }

    private void generalAuthenticateEncryptedNonce() throws Exception {
        GeneralAuthenticate gaEncryptedNonce = new GeneralAuthenticate();
        gaEncryptedNonce.setChaining();
        byte[] keyPI = this.kdf.derivePI(this.password);
        try {
            this.response = gaEncryptedNonce.transmit(this.dispatcher, this.slotHandle);
            this.s = this.cryptoSuite.decryptNonce(keyPI, this.response.getData());
            this.generalAuthenticateMapNonce();
        }
        catch (APDUException e) {
            logger.error(e.getMessage(), e);
            throw new ProtocolException(e.getResult());
        }
        catch (GeneralSecurityException e) {
            logger.error(e.getMessage(), e);
            throw new ProtocolException(e.getMessage());
        }
    }

    private void generalAuthenticateMapNonce() throws Exception {
        byte[] pkMapPCD = null;
        PACEMapping mapping = this.cryptoSuite.getMapping();
        if (mapping instanceof PACEGenericMapping) {
            PACEGenericMapping gm = (PACEGenericMapping)mapping;
            pkMapPCD = gm.getMappingKey().getEncodedPublicKey();
        } else if (mapping instanceof PACEIntegratedMapping) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
        GeneralAuthenticate gaMapNonce = new GeneralAuthenticate(-127, pkMapPCD);
        gaMapNonce.setChaining();
        try {
            this.response = gaMapNonce.transmit(this.dispatcher, this.slotHandle);
        }
        catch (APDUException e) {
            logger.error(e.getMessage(), e);
            throw new ProtocolException(e.getResult());
        }
        if (mapping instanceof PACEGenericMapping) {
            PACEGenericMapping gm = (PACEGenericMapping)mapping;
            PACEKey keyMapPICC = new PACEKey(this.domainParameter);
            keyMapPICC.decodePublicKey(this.response.getData());
            byte[] pkMapPICC = keyMapPICC.getEncodedPublicKey();
            if (ByteUtils.compare(pkMapPICC, pkMapPCD)) {
                throw new GeneralSecurityException("PACE security violation: equal keys");
            }
            this.domainParameter = gm.map(pkMapPICC, this.s);
        } else if (mapping instanceof PACEIntegratedMapping) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
        this.generalAuthenticateKeyAgreement();
    }

    private void generalAuthenticateKeyAgreement() throws Exception {
        this.keyPCD = new PACEKey(this.domainParameter);
        this.keyPCD.generateKeyPair();
        byte[] keyPKPCD = this.keyPCD.getEncodedPublicKey();
        GeneralAuthenticate gaKeyAgreement = new GeneralAuthenticate(-125, keyPKPCD);
        gaKeyAgreement.setChaining();
        try {
            this.response = gaKeyAgreement.transmit(this.dispatcher, this.slotHandle);
            this.keyPICC = new PACEKey(this.domainParameter);
            byte[] keyPKPICC = this.keyPICC.decodePublicKey(this.response.getData());
            if (ByteUtils.compare(keyPKPCD, keyPKPICC)) {
                throw new GeneralSecurityException("PACE security violation: equal keys");
            }
            this.generalAuthenticateMutualAuthentication();
        }
        catch (APDUException e) {
            logger.error(e.getMessage(), e);
            throw new ProtocolException(e.getResult());
        }
        catch (GeneralSecurityException e) {
            logger.error(e.getMessage(), e);
            throw new ProtocolException(e.getMessage());
        }
    }

    private void generalAuthenticateMutualAuthentication() throws Exception {
        byte[] k = this.cryptoSuite.generateSharedSecret(this.keyPCD.getEncodedPrivateKey(), this.keyPICC.getEncodedPublicKey());
        this.keyMAC = this.kdf.deriveMAC(k);
        this.keyENC = this.kdf.deriveENC(k);
        AuthenticationToken tokenPCD = new AuthenticationToken(this.psip.getPACEInfo());
        tokenPCD.generateToken(this.keyMAC, this.keyPICC.getEncodedPublicKey());
        GeneralAuthenticate gaMutualAuth = new GeneralAuthenticate(-123, tokenPCD.toByteArray());
        AuthenticationToken tokenPICC = new AuthenticationToken(this.psip.getPACEInfo());
        tokenPICC.generateToken(this.keyMAC, this.keyPCD.getEncodedPublicKey());
        try {
            this.response = gaMutualAuth.transmit(this.dispatcher, this.slotHandle);
            if (!tokenPICC.verifyToken(this.response.getData(), this.specifiedCHAT)) {
                throw new GeneralSecurityException("Cannot verify authentication token.");
            }
            this.currentCAR = tokenPICC.getCurrentCAR();
            this.previousCAR = tokenPICC.getPreviousCAR();
        }
        catch (APDUException e) {
            logger.error(e.getMessage(), e);
            short sw = e.getResponseAPDU().getSW();
            if ((sw & 0xFFFFFFF0) == 25536) {
                this.retryCounter = (byte)(sw & 0xF);
                if (this.retryCounter == 0) {
                    logger.warn("The password is blocked. The password MUST be unblocked.");
                    throw new ProtocolException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordBlocked", "The password is blocked. The password MUST be unblocked.");
                }
                if (this.retryCounter == 1) {
                    logger.warn("The password is suspended. The password MUST be resumed.");
                    throw new ProtocolException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordSuspended", "The password is suspended. The password MUST be resumed.");
                }
                if (this.retryCounter == 2) {
                    logger.warn("The password is wrong.");
                    throw new ProtocolException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordError", "The password is wrong.");
                }
            }
            throw new ProtocolException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/authenticationFailed", "Authentication failed.");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new ProtocolException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/unknownError", e.getMessage());
        }
    }

    public byte[] getCurrentCAR() {
        return this.currentCAR;
    }

    public byte[] getPreviousCAR() {
        return this.previousCAR;
    }

    public byte[] getKeyMAC() {
        return this.keyMAC;
    }

    public byte[] getKeyENC() {
        return this.keyENC;
    }

    public byte[] getIDPICC() {
        return this.keyPICC.getEncodedCompressedPublicKey();
    }

    public byte getRetryCounter() {
        return this.retryCounter;
    }
}

