/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.event;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import org.openecard.common.event.EventType;
import org.openecard.common.event.IfdEventObject;
import org.openecard.common.interfaces.CardRecognition;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.interfaces.RecognitionException;
import org.openecard.common.util.HandlerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recognizer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Recognizer.class);
    private final Environment env;
    private final ConnectionHandleType handle;
    private final String ifaceProtocol;

    public Recognizer(Environment env, ConnectionHandleType handle, String ifaceProtocol) {
        this.env = env;
        this.handle = handle;
        this.ifaceProtocol = ifaceProtocol;
    }

    @Override
    public void run() {
        ConnectionHandleType newHandle = this.recognizeSlot();
        if (newHandle != null) {
            LOG.debug("Found a recognized card event ({}).", (Object)this.handle.getIFDName());
            this.env.getEventDispatcher().notify(EventType.CARD_RECOGNIZED, new IfdEventObject(newHandle, this.ifaceProtocol));
        }
    }

    private ConnectionHandleType recognizeSlot() {
        ConnectionHandleType.RecognitionInfo rInfo = null;
        ConnectionHandleType.RecognitionInfo currentInfo = this.handle.getRecognitionInfo();
        if (currentInfo == null || currentInfo.getCardIdentifier() == null) {
            LOG.error("Current recognition info or CardIdentifier is null.");
        } else if (this.env.getCIFProvider().needsRecognition(this.handle.getRecognitionInfo().getCardIdentifier())) {
            try {
                CardRecognition cr = this.env.getRecognition();
                rInfo = cr.recognizeCard(this.handle.getContextHandle(), this.handle.getIFDName(), this.handle.getSlotIndex());
            }
            catch (RecognitionException cr) {
                // empty catch block
            }
        }
        if (rInfo != null) {
            ConnectionHandleType newHandle = HandlerUtils.copyHandle(this.handle);
            newHandle.getRecognitionInfo().setCardType(rInfo.getCardType());
            newHandle.getRecognitionInfo().setCardIdentifier(null);
            return newHandle;
        }
        return null;
    }
}

