/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.openecard.common.util.FileUtils;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.swing.components.VirtualPinPadButton;

public class VirtualPinPadDialog
extends JDialog {
    private final JTextComponent inputField;
    private final PasswordField passDef;
    private int numCharsEntered = 0;

    public VirtualPinPadDialog(VirtualPinPadButton pinButton, JTextComponent inputField, PasswordField passDef) {
        super(VirtualPinPadDialog.getOwningWindow(inputField), "PIN-Pad", Dialog.ModalityType.DOCUMENT_MODAL);
        this.inputField = inputField;
        this.passDef = passDef;
        this.inputField.setText("");
        this.setSize(200, 200);
        this.setResizable(false);
        this.setLayout(new BorderLayout(3, 3));
        Point dialogLocation = pinButton.getLocationOnScreen();
        dialogLocation.translate(0, pinButton.getHeight());
        this.setLocation(dialogLocation);
        JPanel buttons = new JPanel(new GridLayout(4, 3, 4, 4));
        this.add((Component)buttons, "Center");
        for (int i = 1; i <= 9; ++i) {
            buttons.add(this.createButton(i));
        }
        buttons.add(this.createRemoveSingleElementButton());
        buttons.add(this.createButton(0));
        buttons.add(this.createCloseButton());
    }

    private JButton createButton(int num) {
        JButton button = new JButton(Integer.toString(num));
        button.addActionListener(new NumberProcessingListener());
        return button;
    }

    private JButton createRemoveSingleElementButton() {
        JButton button = new JButton();
        button.addActionListener(new RemoveSingleElementListener());
        ImageIcon ico = new ImageIcon(FileUtils.resolveResourceAsURL(VirtualPinPadDialog.class, "arrow.png"));
        button.setIcon(ico);
        Insets marginInset = button.getMargin();
        button.setMargin(new Insets(marginInset.top, 5, marginInset.bottom, 5));
        return button;
    }

    private JButton createCloseButton() {
        JButton button = new JButton("OK");
        button.addActionListener(new CloseInputListener());
        Insets marginInset = button.getMargin();
        button.setMargin(new Insets(marginInset.top, 5, marginInset.bottom, 5));
        return button;
    }

    private void setButtonFont(JButton button) {
        Font f = button.getFont();
        f = f.deriveFont(f.getSize2D() + 10.0f);
        button.setFont(f);
    }

    private static Window getOwningWindow(JTextComponent inputField) {
        return SwingUtilities.getWindowAncestor(inputField);
    }

    private class CloseInputListener
    implements ActionListener {
        private CloseInputListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VirtualPinPadDialog.this.dispatchEvent(new WindowEvent(VirtualPinPadDialog.this, 201));
        }
    }

    private class RemoveSingleElementListener
    implements ActionListener {
        private RemoveSingleElementListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String data = VirtualPinPadDialog.this.inputField.getText();
            if (!data.isEmpty()) {
                data = data.substring(0, data.length() - 1);
                VirtualPinPadDialog.this.inputField.setText(data);
                VirtualPinPadDialog.this.numCharsEntered--;
            }
        }
    }

    private class NumberProcessingListener
    implements ActionListener {
        private NumberProcessingListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton b = (JButton)e.getSource();
            String data = VirtualPinPadDialog.this.inputField.getText();
            data = data + b.getText();
            VirtualPinPadDialog.this.inputField.setText(data);
            VirtualPinPadDialog.this.numCharsEntered++;
            if (VirtualPinPadDialog.this.passDef.getMaxLength() > 0 && VirtualPinPadDialog.this.numCharsEntered >= VirtualPinPadDialog.this.passDef.getMaxLength()) {
                VirtualPinPadDialog.this.setVisible(false);
            }
        }
    }
}

