/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing.common;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.openecard.common.util.FileUtils;
import org.openecard.gui.swing.common.GUIProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIDefaults {
    private static final Logger logger = LoggerFactory.getLogger(GUIDefaults.class.getName());
    private static final String HEX_PATTERN = "^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";
    private static final Pattern hexColorPattern = Pattern.compile("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$");
    private static final UIDefaults defaults = UIManager.getDefaults();
    private static final UIDefaults ownDefaults = new UIDefaults();
    private static final ArrayList<String> colorProperties = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("foreground");
            this.add("background");
            this.add("selectionBackground");
            this.add("selectionForeground");
            this.add("disabledText");
        }
    };
    private static final ArrayList<String> fontProperties = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("font");
            this.add("titleFont");
            this.add("acceleratorFont");
        }
    };
    private static final ArrayList<String> iconProperties = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("icon");
            this.add("selectedIcon");
            this.add("disabledIcon");
            this.add("disabledSelectedIcon");
        }
    };

    private static Object getProperty(String identifier) {
        return ownDefaults.get(identifier);
    }

    public static Color getColor(String identifier) {
        Color color = (Color)GUIDefaults.getProperty(identifier);
        if (color == null) {
            return Color.WHITE;
        }
        return color;
    }

    public static Font getFont(String identifier) {
        Font font = (Font)GUIDefaults.getProperty(identifier);
        if (font == null) {
            return new Font("SansSerif", 0, 12);
        }
        return font;
    }

    public static ImageIcon getImage(String identifier, int width, int height) {
        ImageIcon icon = (ImageIcon)GUIDefaults.getProperty(identifier);
        if (width > -1 || height > -1) {
            Image image = icon.getImage();
            image = image.getScaledInstance(width, height, 4);
            icon = new ImageIcon(image);
        }
        return icon;
    }

    public static ImageIcon getImage(String identifier) {
        return GUIDefaults.getImage(identifier, -1, -1);
    }

    public static void initialize() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            GUIProperties guiProps = new GUIProperties();
            Properties props = guiProps.properties();
            for (String property : props.stringPropertyNames()) {
                try {
                    String propertyName = property.substring(0, property.indexOf(46));
                    String propertyAttribute = property.substring(propertyName.length() + 1, property.length());
                    String value = props.getProperty(property);
                    if (colorProperties.contains(propertyAttribute)) {
                        GUIDefaults.validateHexColor(value);
                        if (value.length() == 4) {
                            StringBuilder sb = new StringBuilder("#");
                            for (int i = 1; i < value.length(); ++i) {
                                sb.append(value.substring(i, i + 1));
                                sb.append(value.substring(i, i + 1));
                            }
                            value = sb.toString();
                        }
                        Color color = Color.decode(value);
                        defaults.put(property, color);
                        ownDefaults.put(property, color);
                        continue;
                    }
                    if (fontProperties.contains(propertyAttribute)) {
                        Font font = Font.decode(value);
                        defaults.put(property, font);
                        ownDefaults.put(property, font);
                        continue;
                    }
                    if (!iconProperties.contains(propertyAttribute)) continue;
                    URL url = FileUtils.resolveResourceAsURL(guiProps.getClass(), value);
                    if (url == null) {
                        logger.error("Cannot parse the property: " + property);
                        continue;
                    }
                    Image image = toolkit.getImage(url);
                    ImageIcon icon = new ImageIcon(image);
                    defaults.put(property, icon);
                    ownDefaults.put(property, icon);
                }
                catch (Exception e) {
                    logger.error("Cannot parse the property: " + property);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private static void validateHexColor(String hex) throws IllegalArgumentException {
        if (!hexColorPattern.matcher(hex).matches()) {
            throw new IllegalArgumentException();
        }
    }
}

