/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.file;

import java.io.File;
import org.openecard.gui.file.FileFilter;

public class FileEndingFilter
implements FileFilter {
    private final String fileEnding;

    public FileEndingFilter(String fileEnding, boolean withDot) {
        this.fileEnding = (withDot && !fileEnding.startsWith(".") ? "." : "") + fileEnding;
    }

    public FileEndingFilter(String fileEnding) {
        this(fileEnding, true);
    }

    @Override
    public boolean accept(File f) {
        if (!f.isDirectory()) {
            String name = f.getName();
            return name.endsWith(this.fileEnding);
        }
        return true;
    }

    @Override
    public String getDescription() {
        return "*" + this.fileEnding;
    }
}

