/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.file;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.openecard.gui.file.AcceptAllFilesFilter;
import org.openecard.gui.file.FileFilter;

public class CombiningAndFilter
implements FileFilter {
    private final List<? extends FileFilter> filters;
    private final String description;

    public CombiningAndFilter(FileFilter ... filters) {
        this(Arrays.asList(filters));
    }

    public CombiningAndFilter(List<FileFilter> filters) {
        this.filters = filters.isEmpty() ? Arrays.asList(new AcceptAllFilesFilter()) : filters;
        StringBuilder sb = new StringBuilder(32);
        Iterator<? extends FileFilter> it = this.filters.iterator();
        while (it.hasNext()) {
            sb.append(it.next().getDescription());
            if (!it.hasNext()) continue;
            sb.append("; ");
        }
        this.description = sb.toString();
    }

    @Override
    public boolean accept(File f) {
        for (FileFilter fileFilter : this.filters) {
            if (fileFilter.accept(f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

