/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.executor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.openecard.common.ThreadTerminateException;
import org.openecard.common.interfaces.InvocationTargetExceptionUnchecked;
import org.openecard.gui.ResultStatus;
import org.openecard.gui.StepResult;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.InputInfoUnit;
import org.openecard.gui.definition.OutputInfoUnit;
import org.openecard.gui.definition.Step;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionCallable;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEngine {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionEngine.class);
    private final UserConsentNavigator navigator;
    private final TreeMap<String, ExecutionResults> results = new TreeMap();

    public ExecutionEngine(UserConsentNavigator navigator) {
        this.navigator = navigator;
    }

    public ResultStatus process() throws ThreadTerminateException {
        StepResult next = this.navigator.next();
        block19: while (true) {
            StepActionResult actionResult;
            ResultStatus result;
            if ((result = next.getStatus()) == ResultStatus.INTERRUPTED || Thread.currentThread().isInterrupted()) {
                this.navigator.close();
                throw new ThreadTerminateException("GUI has been interrupted.");
            }
            if (result == ResultStatus.CANCEL) {
                this.navigator.close();
                return result;
            }
            List<OutputInfoUnit> stepResults = next.getResults();
            Map<String, ExecutionResults> oldResults = Collections.unmodifiableMap(this.results);
            this.results.put(next.getStepID(), new ExecutionResults(next.getStepID(), stepResults));
            if (!next.getStep().isResetOnLoad()) {
                Step s = next.getStep();
                List<InputInfoUnit> inputInfo = s.getInputInfoUnits();
                HashMap<String, InputInfoUnit> infoMap = new HashMap<String, InputInfoUnit>();
                for (InputInfoUnit nextInfo : inputInfo) {
                    infoMap.put(nextInfo.getID(), nextInfo);
                }
                for (OutputInfoUnit nextOut : stepResults) {
                    InputInfoUnit matchingInfo = (InputInfoUnit)infoMap.get(nextOut.getID());
                    matchingInfo.copyContentFrom(nextOut);
                }
            }
            if (next.getReplacement() != null) {
                switch (next.getStatus()) {
                    case BACK: {
                        next = this.navigator.replacePrevious(next.getReplacement());
                        continue block19;
                    }
                    case OK: {
                        if (this.navigator.hasNext()) {
                            next = this.navigator.replaceNext(next.getReplacement());
                            continue block19;
                        }
                        this.navigator.close();
                        return this.convertStatus(StepActionResultStatus.NEXT);
                    }
                    case RELOAD: {
                        next = this.navigator.replaceCurrent(next.getReplacement());
                        continue block19;
                    }
                }
                continue;
            }
            StepAction action = next.getStep().getAction();
            StepActionCallable actionCallable = new StepActionCallable(action, oldResults, next);
            ExecutorService execService = Executors.newSingleThreadExecutor();
            Future<StepActionResult> actionFuture = execService.submit(actionCallable);
            this.navigator.setRunningAction(actionFuture);
            try {
                actionResult = actionFuture.get();
            }
            catch (CancellationException ex) {
                LOG.info("StepAction was canceled.", ex);
                this.navigator.close();
                return ResultStatus.CANCEL;
            }
            catch (InterruptedException ex) {
                LOG.info("StepAction was interrupted.", ex);
                this.navigator.close();
                throw new ThreadTerminateException("GUI has been interrupted.");
            }
            catch (ExecutionException ex) {
                InvocationTargetExceptionUnchecked iex;
                if (ex.getCause() instanceof InvocationTargetExceptionUnchecked && (iex = (InvocationTargetExceptionUnchecked)ex.getCause()).getCause() instanceof ThreadTerminateException) {
                    LOG.info("StepAction was interrupted.", ex);
                    this.navigator.close();
                    throw new ThreadTerminateException("GUI has been interrupted.");
                }
                LOG.error("StepAction failed with error.", ex.getCause());
                this.navigator.close();
                return ResultStatus.CANCEL;
            }
            if (actionResult.getStatus() == StepActionResultStatus.CANCEL) {
                LOG.info("StepAction was canceled.");
                this.navigator.close();
                return ResultStatus.CANCEL;
            }
            if (actionResult.getReplacement() != null) {
                switch (actionResult.getStatus()) {
                    case BACK: {
                        next = this.navigator.replacePrevious(actionResult.getReplacement());
                        continue block19;
                    }
                    case NEXT: {
                        if (this.navigator.hasNext()) {
                            next = this.navigator.replaceNext(actionResult.getReplacement());
                            continue block19;
                        }
                        this.navigator.close();
                        return this.convertStatus(StepActionResultStatus.NEXT);
                    }
                    case REPEAT: {
                        next = this.navigator.replaceCurrent(actionResult.getReplacement());
                        continue block19;
                    }
                }
                continue;
            }
            switch (actionResult.getStatus()) {
                case BACK: {
                    next = this.navigator.previous();
                    break;
                }
                case NEXT: {
                    if (this.navigator.hasNext()) {
                        next = this.navigator.next();
                        break;
                    }
                    this.navigator.close();
                    return this.convertStatus(StepActionResultStatus.NEXT);
                }
                case REPEAT: {
                    next = this.navigator.current();
                    break;
                }
            }
        }
    }

    public Map<String, ExecutionResults> getResults() {
        return Collections.unmodifiableMap(this.results);
    }

    private ResultStatus convertStatus(StepActionResultStatus in) {
        switch (in) {
            case BACK: {
                return ResultStatus.BACK;
            }
            case NEXT: {
                return ResultStatus.OK;
            }
        }
        return ResultStatus.OK;
    }
}

