/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.definition;

import java.nio.charset.Charset;
import org.openecard.gui.definition.Document;
import org.openecard.gui.definition.IDTrait;
import org.openecard.gui.definition.InfoUnit;
import org.openecard.gui.definition.InfoUnitElementType;
import org.openecard.gui.definition.InputInfoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Text
extends IDTrait
implements InputInfoUnit {
    private static final Logger _logger = LoggerFactory.getLogger(Text.class);
    private Document document;

    public Text() {
    }

    public Text(String text) {
        this(text.getBytes(Charset.forName("UTF-8")), "text/plain");
    }

    private Text(byte[] value, String mimeType) {
        this.document = new Document();
        this.document.setMimeType(mimeType);
        this.document.setValue(value);
    }

    public Text(Document doc) {
        this.document = doc;
    }

    public String getText() {
        if (this.document == null || this.document.getValue() == null || this.document.getValue().length == 0) {
            return "";
        }
        if (this.document.getMimeType() != null && this.document.getMimeType().startsWith("text/")) {
            return new String(this.document.getValue(), Charset.forName("UTF-8"));
        }
        return "";
    }

    public void setText(String text) {
        if (this.document == null) {
            this.document = new Document();
        }
        this.document.setMimeType("text/plain");
        this.document.setValue(text.getBytes(Charset.forName("UTF-8")));
    }

    public void setDocument(Document doc) {
        this.document = doc;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public InfoUnitElementType type() {
        return InfoUnitElementType.TEXT;
    }

    @Override
    public void copyContentFrom(InfoUnit origin) {
        if (!this.getClass().equals(origin.getClass())) {
            _logger.warn("Trying to copy content from type {} to type {}.", (Object)origin.getClass(), (Object)this.getClass());
            return;
        }
        Text other = (Text)origin;
        if (other.document != null) {
            Document doc = new Document();
            if (other.document.getMimeType() != null) {
                doc.setMimeType(other.document.getMimeType());
            }
            if (other.document.getValue() != null) {
                byte[] contentBytes = new byte[other.document.getValue().length];
                System.arraycopy(other.document.getValue(), 0, contentBytes, 0, other.document.getValue().length);
                doc.setValue(contentBytes);
            }
            this.setDocument(doc);
        }
    }
}

