/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.definition;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.common.util.ValueGenerators;
import org.openecard.gui.definition.InputInfoUnit;
import org.openecard.gui.executor.BackgroundTask;
import org.openecard.gui.executor.DummyAction;
import org.openecard.gui.executor.StepAction;

public class Step {
    private String id;
    private String title;
    private String description;
    private StepAction action;
    private BackgroundTask backgroundTask;
    private boolean reversible;
    private boolean instantReturn;
    private boolean resetOnLoad;
    private List<InputInfoUnit> inputInfoUnits;

    public Step(String title) {
        this(ValueGenerators.genBase64Session(16), title);
    }

    public Step(String id, String title) {
        this.id = id;
        this.title = title;
        this.reversible = true;
        this.instantReturn = false;
        this.resetOnLoad = false;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isReversible() {
        return this.reversible;
    }

    public void setReversible(boolean reversible) {
        this.reversible = reversible;
    }

    public boolean isInstantReturn() {
        return this.instantReturn;
    }

    public void setInstantReturn(boolean instantReturn) {
        this.instantReturn = instantReturn;
    }

    public boolean isResetOnLoad() {
        return this.resetOnLoad;
    }

    public void setResetOnLoad(boolean resetOnLoad) {
        this.resetOnLoad = resetOnLoad;
    }

    public List<InputInfoUnit> getInputInfoUnits() {
        if (this.inputInfoUnits == null) {
            this.inputInfoUnits = new ArrayList<InputInfoUnit>();
        }
        return this.inputInfoUnits;
    }

    public boolean isMetaStep() {
        return this.getInputInfoUnits().isEmpty();
    }

    @Nonnull
    public StepAction getAction() {
        if (this.action == null) {
            return new DummyAction(this);
        }
        return this.action;
    }

    public void setAction(@Nullable StepAction action) {
        this.action = action;
    }

    @Nullable
    public BackgroundTask getBackgroundTask() {
        return this.backgroundTask;
    }

    public void setBackgroundTask(@Nullable BackgroundTask backgroundTask) {
        this.backgroundTask = backgroundTask;
    }
}

