/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.definition;

import java.util.Arrays;
import org.openecard.gui.definition.IDTrait;
import org.openecard.gui.definition.InfoUnit;
import org.openecard.gui.definition.InputInfoUnit;
import org.openecard.gui.definition.OutputInfoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTextField
extends IDTrait
implements InputInfoUnit,
OutputInfoUnit {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTextField.class);
    private String description;
    private char[] value = new char[0];
    private int minLength = 0;
    private int maxLength = Integer.MAX_VALUE;

    public AbstractTextField(String id) {
        super(id);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public char[] getValue() {
        return (char[])this.value.clone();
    }

    public void setValue(char[] value) {
        Arrays.fill(this.value, ' ');
        this.value = (char[])value.clone();
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void copyContentFrom(InfoUnit origin) {
        if (!this.getClass().equals(origin.getClass())) {
            LOG.warn("Trying to copy content from type {} to type {}.", (Object)origin.getClass(), (Object)this.getClass());
            return;
        }
        AbstractTextField other = (AbstractTextField)origin;
        this.description = other.description;
        Arrays.fill(this.value, ' ');
        this.value = (char[])other.value.clone();
        this.minLength = other.minLength;
        this.maxLength = other.maxLength;
    }
}

