/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.definition;

import java.util.ArrayList;
import java.util.List;
import org.openecard.gui.definition.BoxItem;
import org.openecard.gui.definition.IDTrait;
import org.openecard.gui.definition.InfoUnit;
import org.openecard.gui.definition.InputInfoUnit;
import org.openecard.gui.definition.OutputInfoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBox
extends IDTrait
implements InputInfoUnit,
OutputInfoUnit {
    private static final Logger _logger = LoggerFactory.getLogger(AbstractBox.class);
    private String groupText;
    private List<BoxItem> boxItems;

    public AbstractBox(String id) {
        super(id);
    }

    public String getGroupText() {
        return this.groupText;
    }

    public void setGroupText(String groupText) {
        this.groupText = groupText;
    }

    public List<BoxItem> getBoxItems() {
        if (this.boxItems == null) {
            this.boxItems = new ArrayList<BoxItem>();
        }
        return this.boxItems;
    }

    @Override
    public void copyContentFrom(InfoUnit origin) {
        if (!this.getClass().equals(origin.getClass())) {
            _logger.warn("Trying to copy content from type {} to type {}.", (Object)origin.getClass(), (Object)this.getClass());
            return;
        }
        AbstractBox other = (AbstractBox)origin;
        this.groupText = other.groupText;
        this.getBoxItems().clear();
        for (BoxItem next : other.getBoxItems()) {
            BoxItem copy = new BoxItem();
            copy.setChecked(next.isChecked());
            copy.setDisabled(next.isDisabled());
            copy.setName(next.getName());
            copy.setText(next.getText());
            this.getBoxItems().add(copy);
        }
    }
}

