/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.about;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.openecard.common.AppVersion;
import org.openecard.common.I18n;
import org.openecard.common.util.StringUtils;
import org.openecard.gui.graphics.GraphicsUtil;
import org.openecard.gui.graphics.OecLogoBgWhite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutDialog
extends JFrame {
    private static final Logger LOG = LoggerFactory.getLogger(AboutDialog.class);
    private static final long serialVersionUID = 1L;
    private static final I18n LANG = I18n.getTranslation("about");
    public static final String ABOUT_TAB = "about";
    public static final String FEEDBACK_TAB = "feedback";
    public static final String LICENSE_TAB = "license";
    public static final String SUPPORT_TAB = "support";
    private static AboutDialog runningDialog;
    private final HashMap<String, Integer> tabIndices = new HashMap();
    private JTabbedPane tabbedPane;

    private AboutDialog() {
        this.setupUI();
    }

    public static void showDialog(@Nullable String selectedTab) {
        if (runningDialog == null) {
            AboutDialog dialog = new AboutDialog();
            dialog.addWindowListener(new WindowListener(){

                @Override
                public void windowOpened(WindowEvent e) {
                }

                @Override
                public void windowClosing(WindowEvent e) {
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    runningDialog = null;
                }

                @Override
                public void windowIconified(WindowEvent e) {
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                }

                @Override
                public void windowActivated(WindowEvent e) {
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                }
            });
            dialog.setVisible(true);
            runningDialog = dialog;
        } else {
            runningDialog.toFront();
        }
        Integer idx = AboutDialog.runningDialog.tabIndices.get(StringUtils.nullToEmpty(selectedTab));
        if (idx != null) {
            try {
                AboutDialog.runningDialog.tabbedPane.setSelectedIndex(idx);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                LOG.error("Invalid index selected.");
            }
        }
    }

    public static void showDialog() {
        AboutDialog.showDialog(ABOUT_TAB);
    }

    private void setupUI() {
        Image logo = GraphicsUtil.createImage(OecLogoBgWhite.class, 147, 147);
        this.setSize(730, 480);
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(Color.white);
        JTextPane txtpnHeading = new JTextPane();
        txtpnHeading.setFont(new Font("SansSerif", 1, 20));
        txtpnHeading.setEditable(false);
        txtpnHeading.setText(LANG.translationForKey("about.heading", AppVersion.getName()));
        txtpnHeading.setBounds(12, 12, 692, 30);
        this.getContentPane().add(txtpnHeading);
        JTextPane txtpnVersion = new JTextPane();
        txtpnVersion.setFont(new Font("SansSerif", 0, 9));
        txtpnVersion.setEditable(false);
        txtpnVersion.setText(LANG.translationForKey("about.version", AppVersion.getVersion()));
        txtpnVersion.setBounds(12, 54, 692, 18);
        this.getContentPane().add(txtpnVersion);
        JLabel label = new JLabel();
        label.setHorizontalAlignment(0);
        label.setIcon(new ImageIcon(logo));
        label.setBounds(12, 84, 155, 320);
        this.getContentPane().add(label);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setBounds(185, 84, 529, 320);
        this.tabbedPane.setBackground(Color.white);
        int tabIdx = 0;
        this.tabbedPane.addTab(LANG.translationForKey("about.tab.about", new Object[0]), this.createTabContent(ABOUT_TAB));
        this.tabIndices.put(ABOUT_TAB, tabIdx++);
        this.tabbedPane.addTab(LANG.translationForKey("about.tab.feedback", new Object[0]), this.createTabContent(FEEDBACK_TAB));
        this.tabIndices.put(FEEDBACK_TAB, tabIdx++);
        this.tabbedPane.addTab(LANG.translationForKey("about.tab.support", new Object[0]), this.createTabContent(SUPPORT_TAB));
        this.tabIndices.put(SUPPORT_TAB, tabIdx++);
        this.tabbedPane.addTab(LANG.translationForKey("about.tab.license", new Object[0]), this.createTabContent(LICENSE_TAB));
        this.tabIndices.put(LICENSE_TAB, tabIdx++);
        this.getContentPane().add(this.tabbedPane);
        JButton btnClose = new JButton(LANG.translationForKey("about.button.close", new Object[0]));
        btnClose.setBounds(587, 416, 117, 25);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
        this.getContentPane().add(btnClose);
        this.setIconImage(logo);
        this.setTitle(LANG.translationForKey("about.title", AppVersion.getName()));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    private JPanel createTabContent(String resourceName) {
        HTMLEditorKit kit = new HTMLEditorKit();
        HTMLDocument doc = (HTMLDocument)kit.createDefaultDocument();
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setEditorKit(kit);
        editorPane.setDocument(doc);
        try {
            URL url = LANG.translationForFile(resourceName, "html");
            editorPane.setPage(url);
        }
        catch (IOException ex) {
            editorPane.setText("Page not found.");
        }
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                AboutDialog.this.openUrl(e);
            }
        });
        JScrollPane scrollPane = new JScrollPane(editorPane);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    private void openUrl(HyperlinkEvent event) {
        HyperlinkEvent.EventType type = event.getEventType();
        if (type == HyperlinkEvent.EventType.ACTIVATED) {
            String url = event.getURL().toExternalForm();
            try {
                boolean browserOpened = false;
                URI uri = new URI(url);
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    try {
                        Desktop.getDesktop().browse(uri);
                        browserOpened = true;
                    }
                    catch (IOException ex) {
                        LOG.debug(ex.getMessage(), ex);
                    }
                }
                if (!browserOpened) {
                    ProcessBuilder pb = new ProcessBuilder("xdg-open", uri.toString());
                    try {
                        pb.start();
                    }
                    catch (IOException ex) {
                        LOG.debug(ex.getMessage(), ex);
                    }
                }
            }
            catch (URISyntaxException ex) {
                LOG.debug(ex.getMessage(), ex);
            }
        }
    }
}

