/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.verify;

import java.io.IOException;
import org.openecard.bouncycastle.asn1.ASN1Encodable;
import org.openecard.bouncycastle.asn1.x500.RDN;
import org.openecard.bouncycastle.asn1.x500.style.BCStrictStyle;
import org.openecard.bouncycastle.asn1.x509.Certificate;
import org.openecard.bouncycastle.asn1.x509.Extension;
import org.openecard.bouncycastle.asn1.x509.Extensions;
import org.openecard.bouncycastle.asn1.x509.GeneralName;
import org.openecard.bouncycastle.asn1.x509.GeneralNames;
import org.openecard.bouncycastle.tls.TlsServerCertificate;
import org.openecard.bouncycastle.tls.crypto.TlsCertificate;
import org.openecard.bouncycastle.util.IPAddress;
import org.openecard.common.util.DomainUtils;
import org.openecard.crypto.tls.CertificateVerificationException;
import org.openecard.crypto.tls.CertificateVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostnameVerifier
implements CertificateVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(HostnameVerifier.class);

    @Override
    public void isValid(TlsServerCertificate chain, String hostOrIp) throws CertificateVerificationException {
        try {
            TlsCertificate tlsCert = chain.getCertificate().getCertificateAt(0);
            Certificate cert = Certificate.getInstance(tlsCert.getEncoded());
            this.validInt(cert, hostOrIp);
        }
        catch (IOException ex) {
            throw new CertificateVerificationException("Invalid certificate received from server.", ex);
        }
    }

    private void validInt(Certificate cert, String hostOrIp) throws CertificateVerificationException {
        boolean success = false;
        boolean isIPAddr = IPAddress.isValid(hostOrIp);
        if (!isIPAddr) {
            RDN[] cn = cert.getSubject().getRDNs(BCStrictStyle.CN);
            if (cn.length != 0) {
                String hostNameReference = cn[0].getFirst().getValue().toString();
                success = HostnameVerifier.checkWildcardName(hostOrIp, hostNameReference);
            } else {
                LOG.debug("No CN entry in certificate's Subject.");
            }
        } else {
            LOG.debug("Given name is an IP Address. Validation relies solely on the SubjectAlternativeName.");
        }
        if (success) {
            return;
        }
        Extensions ext = cert.getTBSCertificate().getExtensions();
        Extension subjAltExt = ext.getExtension(Extension.subjectAlternativeName);
        if (subjAltExt != null) {
            GeneralName[] names;
            GeneralNames gns = GeneralNames.fromExtensions(ext, Extension.subjectAlternativeName);
            for (GeneralName name : names = gns.getNames()) {
                ASN1Encodable reference = name.getName();
                switch (name.getTagNo()) {
                    case 2: {
                        if (isIPAddr) break;
                        success = HostnameVerifier.checkWildcardName(hostOrIp, reference.toString());
                        break;
                    }
                    case 7: {
                        if (!isIPAddr) break;
                        LOG.warn("IP Address verification not supported.");
                        break;
                    }
                    default: {
                        LOG.debug("Unsupported GeneralName ({}) tag in SubjectAlternativeName.", (Object)name.getTagNo());
                    }
                }
                if (!success) continue;
                return;
            }
        }
        if (!success) {
            String errorMsg = "Hostname in certificate differs from actually requested host.";
            throw new CertificateVerificationException(errorMsg);
        }
    }

    private static boolean checkWildcardName(String givenHost, String wildcardHost) throws CertificateVerificationException {
        LOG.debug("Comparing connection hostname against certificate hostname: [{}] [{}]", (Object)givenHost, (Object)wildcardHost);
        try {
            return DomainUtils.checkHostName(wildcardHost, givenHost, true);
        }
        catch (IllegalArgumentException ex) {
            String msg = "Invalid domain name found in certificate or requested hostname.";
            throw new CertificateVerificationException(msg, ex);
        }
    }
}

