/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.auth;

import iso.std.iso_iec._24727.tech.schema.AlgorithmInfoType;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.DERNull;
import org.openecard.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.openecard.bouncycastle.asn1.x509.DigestInfo;
import org.openecard.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.openecard.bouncycastle.tls.TlsUtils;
import org.openecard.bouncycastle.tls.crypto.TlsSigner;
import org.openecard.bouncycastle.tls.crypto.TlsStreamSigner;
import org.openecard.common.SecurityConditionUnsatisfiable;
import org.openecard.common.WSHelper;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.SignatureAlgorithms;
import org.openecard.crypto.common.UnsupportedAlgorithmException;
import org.openecard.crypto.common.sal.did.DidInfo;
import org.openecard.crypto.common.sal.did.NoSuchDid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardSignerCredential
implements TlsSigner {
    private static final Logger LOG = LoggerFactory.getLogger(SmartCardSignerCredential.class);
    private final DidInfo did;

    public SmartCardSignerCredential(@Nonnull DidInfo info) {
        this.did = info;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        String msg;
        if (algorithm != null && this.isRawSignature()) {
            ASN1ObjectIdentifier hashAlgId = TlsUtils.getOIDForHashAlgorithm(algorithm.getHash());
            DigestInfo digestInfo = new DigestInfo(new AlgorithmIdentifier(hashAlgId, DERNull.INSTANCE), hash);
            hash = digestInfo.getEncoded("DER");
            LOG.debug("Signing DigestInfo with algorithm={}.", (Object)hashAlgId);
        }
        LOG.debug("Signing hash={}.", (Object)ByteUtils.toHexString(hash));
        try {
            this.did.authenticateMissing();
            byte[] sigData = this.did.sign(hash);
            return sigData;
        }
        catch (WSHelper.WSException ex) {
            msg = "Failed to create signature because of an unknown error.";
            LOG.warn(msg, ex);
            throw new IOException(msg, ex);
        }
        catch (SecurityConditionUnsatisfiable ex) {
            msg = "Access to the signature DID could not be obtained.";
            LOG.warn(msg, ex);
            throw new IOException(msg, ex);
        }
        catch (NoSuchDid ex) {
            msg = "Signing DID not available anymore.";
            LOG.warn(msg, ex);
            throw new IOException(msg, ex);
        }
    }

    private boolean isRawSignature() {
        try {
            AlgorithmInfoType algInfo = this.did.getGenericCryptoMarker().getAlgorithmInfo();
            SignatureAlgorithms alg = SignatureAlgorithms.fromAlgId(algInfo.getAlgorithmIdentifier().getAlgorithm());
            return alg == SignatureAlgorithms.CKM_RSA_PKCS;
        }
        catch (WSHelper.WSException | UnsupportedAlgorithmException ex) {
            throw new RuntimeException("Error evaluating algorithm", ex);
        }
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm algorithm) throws IOException {
        return null;
    }
}

