/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.sal.did;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.util.ByteComparator;
import org.openecard.crypto.common.sal.did.DidInfos;

public class TokenCache {
    private final Dispatcher dispatcher;
    private final Map<byte[], DidInfos> cachedInfos;

    public TokenCache(@Nonnull Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.cachedInfos = new TreeMap<byte[], DidInfos>(new ByteComparator());
    }

    public DidInfos getInfo(@Nullable char[] pin, @Nonnull ConnectionHandleType handle) {
        return this.getInfo(pin, handle.getSlotHandle());
    }

    public DidInfos getInfo(@Nullable char[] pin, @Nonnull byte[] slotHandle) {
        DidInfos result = this.cachedInfos.get(slotHandle);
        if (result == null) {
            result = new DidInfos(this.dispatcher, pin, slotHandle);
        }
        return result;
    }

    public void clearPins() {
        for (Map.Entry<byte[], DidInfos> next : this.cachedInfos.entrySet()) {
            byte[] slotHandle = next.getKey();
            DidInfos dids = next.getValue();
            dids.clearPin(slotHandle);
        }
    }
}

