/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.sal.did;

import iso.std.iso_iec._24727.tech.schema.ACLList;
import iso.std.iso_iec._24727.tech.schema.ACLListResponse;
import iso.std.iso_iec._24727.tech.schema.AccessControlListType;
import iso.std.iso_iec._24727.tech.schema.CertificateRefType;
import iso.std.iso_iec._24727.tech.schema.DIDAbstractMarkerType;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDGet;
import iso.std.iso_iec._24727.tech.schema.DIDGetResponse;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.Hash;
import iso.std.iso_iec._24727.tech.schema.HashResponse;
import iso.std.iso_iec._24727.tech.schema.PinCompareDIDAuthenticateInputType;
import iso.std.iso_iec._24727.tech.schema.Sign;
import iso.std.iso_iec._24727.tech.schema.SignResponse;
import iso.std.iso_iec._24727.tech.schema.TargetNameType;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.parsers.ParserConfigurationException;
import org.openecard.common.SecurityConditionUnsatisfiable;
import org.openecard.common.WSHelper;
import org.openecard.common.anytype.pin.PINCompareDIDAuthenticateInputType;
import org.openecard.common.anytype.pin.PINCompareDIDAuthenticateOutputType;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.sal.did.ACLResolver;
import org.openecard.crypto.common.sal.did.CryptoMarkerType;
import org.openecard.crypto.common.sal.did.DataSetInfo;
import org.openecard.crypto.common.sal.did.DidInfos;
import org.openecard.crypto.common.sal.did.NoSuchDataSet;
import org.openecard.crypto.common.sal.did.NoSuchDid;
import org.openecard.crypto.common.sal.did.PinCompareMarkerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DidInfo {
    private static final Logger LOG = LoggerFactory.getLogger(DidInfo.class);
    private final DidInfos didInfos;
    private final byte[] application;
    private final TargetNameType didTarget;
    @Nullable
    private DIDScopeType didScope;
    @Nullable
    private char[] pin;
    private CertificateFactory certFactory;
    private List<X509Certificate> certs;

    DidInfo(DidInfos didInfos, byte[] application, String didName, @Nullable char[] pin) {
        this.didInfos = didInfos;
        this.application = ByteUtils.clone(application);
        this.didTarget = new TargetNameType();
        this.didTarget.setDIDName(didName);
        if (pin != null) {
            Arrays.fill(this.pin, ' ');
            this.pin = (char[])pin.clone();
        } else {
            this.pin = null;
        }
        this.didScope = null;
        try {
            DIDStructureType didStruct = this.getDID();
            if (didStruct != null) {
                this.didScope = didStruct.getDIDScope();
            }
        }
        catch (WSHelper.WSException ex) {
            LOG.warn("Failed to retrieve DID qualifier.");
        }
    }

    DidInfo(DidInfos didInfos, byte[] application, DIDStructureType didStruct, @Nullable char[] pin) {
        this.didInfos = didInfos;
        this.application = ByteUtils.clone(application);
        this.didTarget = new TargetNameType();
        this.didTarget.setDIDName(didStruct.getDIDName());
        this.didScope = didStruct.getDIDScope();
        if (pin != null) {
            Arrays.fill(this.pin, ' ');
            this.pin = (char[])pin.clone();
        } else {
            this.pin = null;
        }
    }

    public void setPin(char[] pin) {
        if (pin != null) {
            Arrays.fill(this.pin, ' ');
            this.pin = (char[])pin.clone();
        } else {
            this.pin = null;
        }
    }

    public AccessControlListType getACL() throws WSHelper.WSException {
        ACLList req = new ACLList();
        req.setConnectionHandle(this.didInfos.getHandle(this.application));
        req.setTargetName(this.didTarget);
        ACLListResponse res = (ACLListResponse)this.didInfos.getDispatcher().safeDeliver(req);
        WSHelper.checkResult(res);
        return res.getTargetACL();
    }

    public DIDStructureType getDID() throws WSHelper.WSException {
        DIDGet req = new DIDGet();
        req.setConnectionHandle(this.didInfos.getHandle(this.application));
        req.setDIDName(this.getDidName());
        req.setDIDScope(this.didScope);
        DIDGetResponse res = (DIDGetResponse)this.didInfos.getDispatcher().safeDeliver(req);
        WSHelper.checkResult(res);
        return res.getDIDStructure();
    }

    public String getDidName() {
        return this.didTarget.getDIDName();
    }

    protected synchronized CertificateFactory getCertFactory() throws CertificateException {
        if (this.certFactory == null) {
            this.certFactory = CertificateFactory.getInstance("X.509");
        }
        return this.certFactory;
    }

    public String getProtocol() throws WSHelper.WSException {
        return this.getDID().getDIDMarker().getProtocol();
    }

    public boolean isAuthenticated() throws WSHelper.WSException {
        return this.getDID().isAuthenticated();
    }

    public List<DIDStructureType> getMissingDids() throws WSHelper.WSException, SecurityConditionUnsatisfiable {
        ACLResolver resolver = new ACLResolver(this.didInfos.getDispatcher(), this.didInfos.getHandle(this.application));
        List<DIDStructureType> missingDids = resolver.getUnsatisfiedDIDs(this.didTarget, this.getACL().getAccessRule());
        return missingDids;
    }

    public List<DidInfo> getMissingDidInfos() throws WSHelper.WSException, SecurityConditionUnsatisfiable, NoSuchDid {
        ArrayList<DidInfo> result = new ArrayList<DidInfo>();
        for (DIDStructureType didStruct : this.getMissingDids()) {
            result.add(this.didInfos.getDidInfo(didStruct.getDIDName()));
        }
        return result;
    }

    public boolean isPinSufficient() throws WSHelper.WSException {
        try {
            List<DIDStructureType> missingDids = this.getMissingDids();
            for (DIDStructureType missingDid : missingDids) {
                DidInfo infoObj = missingDid.getDIDScope() == DIDScopeType.GLOBAL ? this.didInfos.getDidInfo(missingDid.getDIDName()) : this.didInfos.getDidInfo(this.application, missingDid.getDIDName());
                if (infoObj.isPinDid()) continue;
                return false;
            }
            return true;
        }
        catch (SecurityConditionUnsatisfiable ex) {
            return false;
        }
        catch (NoSuchDid ex) {
            String msg = "DID referenced in CIF could not be resolved.";
            LOG.error(msg, ex);
            throw WSHelper.createException(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", msg));
        }
    }

    public boolean needsPin() throws WSHelper.WSException, SecurityConditionUnsatisfiable {
        try {
            List<DIDStructureType> missingDids = this.getMissingDids();
            for (DIDStructureType missingDid : missingDids) {
                DidInfo infoObj = missingDid.getDIDScope() == DIDScopeType.GLOBAL ? this.didInfos.getDidInfo(missingDid.getDIDName()) : this.didInfos.getDidInfo(this.application, missingDid.getDIDName());
                if (!infoObj.isPinDid()) continue;
                return true;
            }
            return false;
        }
        catch (NoSuchDid ex) {
            String msg = "DID referenced in CIF could not be resolved.";
            LOG.error(msg, ex);
            throw WSHelper.createException(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", msg));
        }
    }

    public DIDAbstractMarkerType getRawMarker() throws WSHelper.WSException {
        return this.getDID().getDIDMarker();
    }

    public boolean isPinDid() throws WSHelper.WSException {
        return "urn:oid:1.3.162.15480.3.0.9".equals(this.getProtocol());
    }

    public PinCompareMarkerType getPinCompareMarker() throws WSHelper.WSException {
        return new PinCompareMarkerType(this.getDID().getDIDMarker());
    }

    @Nullable
    public BigInteger enterPin(@Nullable char[] pin) throws WSHelper.WSException {
        if (!this.isPinDid()) {
            throw new IllegalStateException("Enter PIN called for a DID which is not a PIN DID.");
        }
        try {
            PinCompareDIDAuthenticateInputType data = new PinCompareDIDAuthenticateInputType();
            data.setProtocol(this.getProtocol());
            if (pin != null && pin.length != 0) {
                PINCompareDIDAuthenticateInputType builder = new PINCompareDIDAuthenticateInputType(data);
                builder.setPIN(pin);
                data = builder.getAuthDataType();
                builder.setPIN(null);
            }
            DIDAuthenticate req = new DIDAuthenticate();
            req.setConnectionHandle(this.didInfos.getHandle(this.application));
            req.setDIDName(this.didTarget.getDIDName());
            req.setDIDScope(this.didScope);
            req.setAuthenticationProtocolData(data);
            DIDAuthenticateResponse res = (DIDAuthenticateResponse)this.didInfos.getDispatcher().safeDeliver(req);
            WSHelper.checkResult(res);
            PINCompareDIDAuthenticateOutputType protoData = new PINCompareDIDAuthenticateOutputType(res.getAuthenticationProtocolData());
            BigInteger retryCounter = protoData.getRetryCounter();
            return retryCounter;
        }
        catch (ParserConfigurationException ex) {
            String msg = "Unexpected protocol data received in PIN Compare output.";
            LOG.error(msg, ex);
            throw new IllegalStateException(msg);
        }
    }

    @Nullable
    public BigInteger enterPin() throws WSHelper.WSException {
        return this.enterPin(this.pin);
    }

    public boolean isCryptoDid() throws WSHelper.WSException {
        return "urn:oid:1.3.162.15480.3.0.25".equals(this.getProtocol());
    }

    public CryptoMarkerType getGenericCryptoMarker() throws WSHelper.WSException {
        return new CryptoMarkerType(this.getDID().getDIDMarker());
    }

    public byte[] hash(byte[] data) throws WSHelper.WSException {
        if (!this.isCryptoDid()) {
            throw new IllegalStateException("Hash called for a DID which is not a Generic Crypto DID.");
        }
        Hash hashReq = new Hash();
        hashReq.setMessage(data);
        hashReq.setDIDName(this.didTarget.getDIDName());
        hashReq.setDIDScope(DIDScopeType.LOCAL);
        hashReq.setConnectionHandle(this.didInfos.getHandle(this.application));
        HashResponse res = (HashResponse)this.didInfos.getDispatcher().safeDeliver(hashReq);
        WSHelper.checkResult(res);
        byte[] digest = res.getHash();
        return digest;
    }

    public byte[] sign(byte[] data) throws WSHelper.WSException {
        if (!this.isCryptoDid()) {
            throw new IllegalStateException("Sign called for a DID which is not a Generic Crypto DID.");
        }
        Sign sign = new Sign();
        sign.setMessage(data);
        sign.setDIDName(this.didTarget.getDIDName());
        sign.setDIDScope(DIDScopeType.LOCAL);
        sign.setConnectionHandle(this.didInfos.getHandle(this.application));
        SignResponse res = (SignResponse)this.didInfos.getDispatcher().safeDeliver(sign);
        WSHelper.checkResult(res);
        byte[] sig = res.getSignature();
        return sig;
    }

    public List<DataSetInfo> getRelatedDataSets() throws WSHelper.WSException {
        try {
            ArrayList<DataSetInfo> result = new ArrayList<DataSetInfo>();
            HashSet<String> foundDataSets = new HashSet<String>();
            if (this.isCryptoDid()) {
                CryptoMarkerType m = this.getGenericCryptoMarker();
                for (CertificateRefType cert : m.getCertificateRefs()) {
                    String datasetName = cert.getDataSetName();
                    if (foundDataSets.contains(datasetName)) continue;
                    DataSetInfo ds = this.didInfos.getDataSetInfo(this.application, datasetName);
                    result.add(ds);
                    foundDataSets.add(datasetName);
                }
            }
            return Collections.unmodifiableList(result);
        }
        catch (NoSuchDataSet ex) {
            String msg = "DataSet referenced in CIF could not be resolved.";
            LOG.error(msg, ex);
            throw WSHelper.createException(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", msg));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized List<X509Certificate> getRelatedCertificateChain() throws WSHelper.WSException, CertificateException, SecurityConditionUnsatisfiable, NoSuchDid {
        if (this.certs != null) return this.certs;
        if (this.isCryptoDid()) {
            boolean allCertsRead = true;
            ArrayList<byte[]> rawCerts = new ArrayList<byte[]>();
            for (DataSetInfo dsi : this.getRelatedDataSets()) {
                if (dsi.isPinSufficient()) {
                    dsi.connectApplication();
                    dsi.authenticate();
                    byte[] data = dsi.read();
                    rawCerts.add(data);
                    continue;
                }
                allCertsRead = false;
                break;
            }
            if (!allCertsRead) throw new CertificateException("No readable certificates available.");
            this.certs = this.parseCerts(rawCerts);
            return this.certs;
        } else {
            this.certs = Collections.emptyList();
        }
        return this.certs;
    }

    private List<X509Certificate> parseCerts(List<byte[]> certsData) throws CertificateException {
        ArrayList<? extends Certificate> allCerts = new ArrayList<Certificate>();
        for (byte[] nextBlob : certsData) {
            allCerts.addAll(this.getCertFactory().generateCertificates(new ByteArrayInputStream(nextBlob)));
        }
        if (!allCerts.isEmpty()) {
            return this.getCertFactory().generateCertPath(allCerts).getCertificates();
        }
        return Collections.emptyList();
    }

    public void connectApplication() throws WSHelper.WSException {
        this.didInfos.connectApplication(this.application);
    }

    public void authenticateMissing() throws WSHelper.WSException, SecurityConditionUnsatisfiable, NoSuchDid {
        for (DidInfo nextDid : this.getMissingDidInfos()) {
            if (nextDid.isPinDid()) {
                nextDid.enterPin(this.pin);
                continue;
            }
            throw new SecurityConditionUnsatisfiable("Only PIN DIDs are supported at the moment.");
        }
    }
}

