/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.keystore;

import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.crypto.CryptoException;
import org.openecard.bouncycastle.crypto.Signer;
import org.openecard.bouncycastle.crypto.digests.NullDigest;
import org.openecard.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.openecard.bouncycastle.crypto.engines.RSABlindedEngine;
import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.crypto.params.ParametersWithRandom;
import org.openecard.bouncycastle.crypto.signers.GenericSigner;
import org.openecard.bouncycastle.crypto.signers.RSADigestSigner;
import org.openecard.bouncycastle.crypto.util.PrivateKeyFactory;
import org.openecard.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.openecard.bouncycastle.tls.TlsUtils;
import org.openecard.crypto.common.ReusableSecureRandom;
import org.openecard.crypto.common.sal.did.CredentialPermissionDenied;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreSigner {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreSigner.class);
    private final KeyStore keyStore;
    private final char[] password;
    private final String alias;

    public KeyStoreSigner(@Nonnull KeyStore keyStore, char[] password, String alias) {
        this.keyStore = keyStore;
        this.password = password;
        this.alias = alias;
    }

    private Certificate[] getJCACertificateChain() throws KeyStoreException, CertificateException {
        Certificate[] cert = this.keyStore.getCertificateChain(this.alias);
        if (cert == null) {
            throw new CertificateException("Unknown alias.");
        }
        return cert;
    }

    public byte[] sign(@Nullable SignatureAndHashAlgorithm sigHashAlg, @Nonnull byte[] hash) throws SignatureException, CredentialPermissionDenied {
        try {
            Signer signer;
            Key key = this.keyStore.getKey(this.alias, this.password);
            if (!(key instanceof RSAPrivateKey)) {
                throw new SignatureException("No private key available for the sign operation.");
            }
            PrivateKey pKey = (PrivateKey)key;
            AsymmetricKeyParameter bcKey = PrivateKeyFactory.createKey(pKey.getEncoded());
            if (sigHashAlg == null) {
                signer = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), new NullDigest());
            } else {
                ASN1ObjectIdentifier hashOid = TlsUtils.getOIDForHashAlgorithm(sigHashAlg.getHash());
                signer = new RSADigestSigner(new NullDigest(), hashOid);
            }
            signer.init(true, new ParametersWithRandom(bcKey, ReusableSecureRandom.getInstance()));
            signer.update(hash, 0, hash.length);
            byte[] signature = signer.generateSignature();
            return signature;
        }
        catch (KeyStoreException ex) {
            throw new IllegalStateException("Keystore is not initialized.");
        }
        catch (UnrecoverableKeyException ex) {
            throw new CredentialPermissionDenied("No usable key could be retrieved from the keystore.", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SignatureException("Requested algorithm is not available.", ex);
        }
        catch (IOException ex) {
            throw new SignatureException("Failed to convert private key to BC class.");
        }
        catch (CryptoException ex) {
            throw new SignatureException("Failed to compute signature.", ex);
        }
    }
}

