/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import org.openecard.bouncycastle.asn1.ASN1Integer;
import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.crypto.common.asn1.eac.SecurityInfo;

public final class CAInfo
extends SecurityInfo {
    private String protocol = this.getIdentifier();
    private int version = ((ASN1Integer)this.getRequiredData()).getValue().intValue();
    private int keyID;
    private static final String[] protocols = new String[]{"0.4.0.127.0.7.2.2.3.1.1", "0.4.0.127.0.7.2.2.3.1.2", "0.4.0.127.0.7.2.2.3.1.3", "0.4.0.127.0.7.2.2.3.1.4", "0.4.0.127.0.7.2.2.3.2.1", "0.4.0.127.0.7.2.2.3.2.2", "0.4.0.127.0.7.2.2.3.2.3", "0.4.0.127.0.7.2.2.3.2.4"};

    public CAInfo(ASN1Sequence seq) {
        super(seq);
        if (seq.size() == 3) {
            this.keyID = ((ASN1Integer)this.getOptionalData()).getValue().intValue();
        }
    }

    public boolean isDH() {
        return this.protocol.startsWith("0.4.0.127.0.7.2.2.3.1");
    }

    public boolean isECDH() {
        return this.protocol.startsWith("0.4.0.127.0.7.2.2.3.2");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getVersion() {
        return this.version;
    }

    public int getKeyID() {
        return this.keyID;
    }

    public static boolean isObjectIdentifier(String oid) {
        for (int i = 0; i < protocols.length; ++i) {
            if (!protocols[i].equals(oid)) continue;
            return true;
        }
        return false;
    }
}

