/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.cvc;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.ASN1OctetString;
import org.openecard.bouncycastle.asn1.ASN1Primitive;
import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.bouncycastle.asn1.ASN1Set;
import org.openecard.bouncycastle.asn1.ASN1String;
import org.openecard.bouncycastle.asn1.ASN1TaggedObject;
import org.openecard.bouncycastle.asn1.DERTaggedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateDescription {
    private static final Logger _logger = LoggerFactory.getLogger(CertificateDescription.class);
    private String descriptionType;
    private String issuerName;
    private String issuerURL;
    private String subjectName;
    private String subjectURL;
    private String termsOfUsage;
    private byte[] termsOfUsageBytes;
    private String redirectURL;
    private ArrayList<byte[]> commCertificates;
    private byte[] encoded;
    private String termsOfUsageMimeType;

    public static CertificateDescription getInstance(Object obj) throws CertificateException {
        if (obj instanceof CertificateDescription) {
            return (CertificateDescription)obj;
        }
        if (obj instanceof ASN1Set) {
            return new CertificateDescription((ASN1Sequence)obj);
        }
        if (obj instanceof byte[]) {
            try {
                return new CertificateDescription((ASN1Sequence)ASN1Sequence.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                _logger.error("Cannot parse CertificateDescription", e);
                throw new IllegalArgumentException("Cannot parse CertificateDescription");
            }
        }
        throw new IllegalArgumentException("Unknown object in factory: " + obj.getClass());
    }

    private CertificateDescription(ASN1Sequence seq) throws CertificateException {
        try {
            this.encoded = seq.getEncoded();
            Enumeration elements = seq.getObjects();
            this.descriptionType = ASN1ObjectIdentifier.getInstance(elements.nextElement()).toString();
            block21: while (elements.hasMoreElements()) {
                ASN1TaggedObject taggedObject = DERTaggedObject.getInstance(elements.nextElement());
                int tag = taggedObject.getTagNo();
                ASN1Primitive obj = taggedObject.getObject();
                switch (tag) {
                    case 1: {
                        this.issuerName = ((ASN1String)((Object)obj)).getString();
                        continue block21;
                    }
                    case 2: {
                        this.issuerURL = ((ASN1String)((Object)obj)).getString();
                        continue block21;
                    }
                    case 3: {
                        this.subjectName = ((ASN1String)((Object)obj)).getString();
                        continue block21;
                    }
                    case 4: {
                        this.subjectURL = ((ASN1String)((Object)obj)).getString();
                        continue block21;
                    }
                    case 5: {
                        switch (this.descriptionType) {
                            case "0.4.0.127.0.7.3.1.3.1.1": {
                                this.termsOfUsageMimeType = "text/plain";
                                this.termsOfUsage = ((ASN1String)((Object)obj)).getString();
                                break;
                            }
                            case "0.4.0.127.0.7.3.1.3.1.2": {
                                this.termsOfUsageMimeType = "text/html";
                                this.termsOfUsage = ((ASN1String)((Object)obj)).getString();
                                break;
                            }
                            case "0.4.0.127.0.7.3.1.3.1.3": {
                                this.termsOfUsageMimeType = "application/pdf";
                                this.termsOfUsageBytes = ((ASN1OctetString)obj).getOctets();
                            }
                        }
                        continue block21;
                    }
                    case 6: {
                        this.redirectURL = ((ASN1String)((Object)obj)).getString();
                        continue block21;
                    }
                    case 7: {
                        Enumeration commCerts = ((ASN1Set)obj).getObjects();
                        this.commCertificates = new ArrayList();
                        while (commCerts.hasMoreElements()) {
                            this.commCertificates.add(((ASN1OctetString)commCerts.nextElement()).getOctets());
                        }
                        continue block21;
                    }
                }
                throw new IllegalArgumentException("Unknown object in CertificateDescription.");
            }
        }
        catch (IOException e) {
            _logger.error("Cannot parse CertificateDescription.", e);
            throw new CertificateException("Cannot parse CertificateDescription.");
        }
    }

    public String getDescriptionType() {
        return this.descriptionType;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public String getIssuerURL() {
        return this.issuerURL;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public String getSubjectURL() {
        return this.subjectURL;
    }

    @Deprecated
    public Object getTermsOfUsage() {
        return this.termsOfUsage;
    }

    public String getTermsOfUsageString() {
        if (this.termsOfUsage != null) {
            return this.termsOfUsage;
        }
        throw new IllegalStateException("Terms of usage are not available in a string type.");
    }

    public byte[] getTermsOfUsageBytes() {
        if (this.termsOfUsageBytes != null) {
            return this.termsOfUsageBytes;
        }
        return this.termsOfUsage.getBytes(Charset.forName("UTF-8"));
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public ArrayList<byte[]> getCommCertificates() {
        return this.commCertificates;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public String getTermsOfUsageMimeType() {
        return this.termsOfUsageMimeType;
    }

    public boolean isTermsOfUsagePdf() {
        return this.termsOfUsageMimeType.equals("application/pdf");
    }

    public boolean isTermsOfUsageHtml() {
        return this.termsOfUsageMimeType.equals("text/html");
    }

    public boolean isTermsOfUsageText() {
        return this.termsOfUsageMimeType.equals("text/plain");
    }
}

