/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.crypto.common.HashAlgorithms;
import org.openecard.crypto.common.KeyTypes;
import org.openecard.crypto.common.UnsupportedAlgorithmException;

public enum SignatureAlgorithms {
    CKM_RSA_PKCS(1L, "NONEwithRSA", "http://ws.openecard.org/alg/rsa", KeyTypes.CKK_RSA, null),
    CKM_SHA1_RSA_PKCS(6L, "SHA1withRSA", "http://www.w3.org/2000/09/xmldsig#rsa-sha1", KeyTypes.CKK_RSA, HashAlgorithms.CKM_SHA_1),
    CKM_RSA_PKCS_PSS(13L, "NONEwithRSAandMGF1", "http://ws.openecard.org/alg/rsa-MGF1", KeyTypes.CKK_RSA, null),
    CKM_SHA1_RSA_PKCS_PSS(14L, "SHA1withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1", KeyTypes.CKK_RSA, HashAlgorithms.CKM_SHA_1),
    CKM_SHA256_RSA_PKCS(64L, "SHA256withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", KeyTypes.CKK_RSA, HashAlgorithms.CKM_SHA256),
    CKM_SHA384_RSA_PKCS(65L, "SHA384withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", KeyTypes.CKK_RSA, HashAlgorithms.CKM_SHA384),
    CKM_SHA512_RSA_PKCS(66L, "SHA512withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", KeyTypes.CKK_RSA, HashAlgorithms.CKM_SHA512),
    CKM_SHA256_RSA_PKCS_PSS(67L, "SHA256withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1", KeyTypes.CKK_RSA, HashAlgorithms.CKM_SHA256),
    CKM_SHA384_RSA_PKCS_PSS(68L, "SHA384withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1", KeyTypes.CKK_RSA, HashAlgorithms.CKM_SHA384),
    CKM_SHA512_RSA_PKCS_PSS(69L, "SHA512withRSA", "http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1", KeyTypes.CKK_RSA, HashAlgorithms.CKM_SHA512),
    CKM_SHA224_RSA_PKCS(70L, "SHA224withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha224", KeyTypes.CKK_RSA, HashAlgorithms.CKM_SHA224),
    CKM_SHA224_RSA_PKCS_PSS(71L, "SHA224withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1", KeyTypes.CKK_RSA, HashAlgorithms.CKM_SHA224),
    CKM_ECDSA(4161L, "NONEwithECDSA", "http://ws.openecard.org/alg/ecdsa", KeyTypes.CKK_EC, null),
    CKM_ECDSA_SHA1(4162L, "SHA1withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", KeyTypes.CKK_EC, HashAlgorithms.CKM_SHA_1),
    CKM_ECDSA_SHA224(4163L, "SHA224withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224", KeyTypes.CKK_EC, HashAlgorithms.CKM_SHA224),
    CKM_ECDSA_SHA256(4164L, "SHA256withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", KeyTypes.CKK_EC, HashAlgorithms.CKM_SHA256),
    CKM_ECDSA_SHA384(4165L, "SHA384withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", KeyTypes.CKK_EC, HashAlgorithms.CKM_SHA384),
    CKM_ECDSA_SHA512(4166L, "SHA512withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", KeyTypes.CKK_EC, HashAlgorithms.CKM_SHA512);

    private static final HashMap<Long, SignatureAlgorithms> mechanismLookup;
    private static final HashMap<String, SignatureAlgorithms> jcaLookup;
    private static final HashMap<String, SignatureAlgorithms> algIdLookup;
    private final long pkcs11MechanismId;
    private final String jcaAlg;
    private final String algId;
    private final KeyTypes keyType;
    private final HashAlgorithms hashAlg;

    private SignatureAlgorithms(@Nonnull long id, @Nonnull String jcaAlg, @Nullable String algId, KeyTypes keyType, HashAlgorithms hashAlg) {
        this.pkcs11MechanismId = id;
        this.jcaAlg = jcaAlg;
        this.algId = algId;
        this.keyType = keyType;
        this.hashAlg = hashAlg;
    }

    @Nonnull
    public long getPkcs11Mechanism() {
        return this.pkcs11MechanismId;
    }

    @Nonnull
    public String getJcaAlg() {
        return this.jcaAlg;
    }

    @Nonnull
    public String getAlgId() {
        return this.algId;
    }

    @Nonnull
    public KeyTypes getKeyType() {
        return this.keyType;
    }

    @Nullable
    public HashAlgorithms getHashAlg() {
        return this.hashAlg;
    }

    @Nonnull
    public static SignatureAlgorithms fromMechanismId(long id) throws UnsupportedAlgorithmException {
        SignatureAlgorithms result = mechanismLookup.get(id);
        if (result == null) {
            throw new UnsupportedAlgorithmException(String.format("No mechanism defined for ID %08x.", id));
        }
        return result;
    }

    @Nonnull
    public static SignatureAlgorithms fromJcaName(String jcaName) throws UnsupportedAlgorithmException {
        SignatureAlgorithms a = jcaLookup.get(jcaName);
        if (a == null) {
            throw new UnsupportedAlgorithmException("No JCA Name " + jcaName + " available.");
        }
        return a;
    }

    @Nonnull
    public static SignatureAlgorithms fromAlgId(String algId) throws UnsupportedAlgorithmException {
        SignatureAlgorithms a = algIdLookup.get(algId);
        if (a == null) {
            throw new UnsupportedAlgorithmException("No Algorithm ID " + algId + " available.");
        }
        return a;
    }

    @Nonnull
    public static String algIdtoJcaName(@Nonnull String oid) throws UnsupportedAlgorithmException {
        SignatureAlgorithms m = algIdLookup.get(oid);
        if (m == null) {
            throw new UnsupportedAlgorithmException("No JCA Name available for OID " + oid + ".");
        }
        return m.getJcaAlg();
    }

    @Nonnull
    public static String jcaNameToAlgId(@Nonnull String jcaAlgName) throws UnsupportedAlgorithmException {
        SignatureAlgorithms m = jcaLookup.get(jcaAlgName);
        if (m == null) {
            throw new UnsupportedAlgorithmException("No OID available for JCA Name " + jcaAlgName + ".");
        }
        return m.getAlgId();
    }

    static {
        SignatureAlgorithms[] values = SignatureAlgorithms.values();
        mechanismLookup = new HashMap(values.length);
        jcaLookup = new HashMap(values.length);
        algIdLookup = new HashMap(values.length);
        for (SignatureAlgorithms next : values) {
            mechanismLookup.put(next.getPkcs11Mechanism(), next);
            if (next.jcaAlg != null) {
                jcaLookup.put(next.jcaAlg, next);
            }
            if (next.algId == null) continue;
            algIdLookup.put(next.algId, next);
        }
    }
}

