/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common;

import javax.annotation.Nonnull;

public enum HashAlgorithms {
    CKM_SHA_1(544L, "SHA-1", "http://www.w3.org/2000/09/xmldsig#sha1"),
    CKM_SHA256(592L, "SHA-256", "http://www.w3.org/2001/04/xmlenc#sha256"),
    CKM_SHA224(597L, "SHA-224", "http://www.w3.org/2001/04/xmldsig-more#sha224"),
    CKM_SHA384(608L, "SHA-384", "http://www.w3.org/2001/04/xmldsig-more#sha384"),
    CKM_SHA512(624L, "SHA-512", "http://www.w3.org/2001/04/xmlenc#sha512");

    private final long pkcs11MechanismId;
    private final String jcaAlg;
    private final String algId;

    private HashAlgorithms(long id, String jcaAlg, String algId) {
        this.pkcs11MechanismId = id;
        this.jcaAlg = jcaAlg;
        this.algId = algId;
    }

    public long getPkcs11Mechanism() {
        return this.pkcs11MechanismId;
    }

    @Nonnull
    public String getJcaAlg() {
        return this.jcaAlg;
    }

    @Nonnull
    public String getAlgId() {
        return this.algId;
    }
}

