/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.handler;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.openecard.addon.AddonManager;
import org.openecard.addon.AddonNotFoundException;
import org.openecard.addon.AddonSelector;
import org.openecard.addon.bind.AppPluginAction;
import org.openecard.addon.bind.BindingResult;
import org.openecard.addon.bind.BindingResultCode;
import org.openecard.addon.bind.Headers;
import org.openecard.addon.bind.RequestBody;
import org.openecard.addon.bind.ResponseBody;
import org.openecard.apache.http.Header;
import org.openecard.apache.http.HeaderIterator;
import org.openecard.apache.http.HttpEntity;
import org.openecard.apache.http.HttpEntityEnclosingRequest;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.ParseException;
import org.openecard.apache.http.entity.ContentType;
import org.openecard.apache.http.entity.StringEntity;
import org.openecard.apache.http.protocol.HttpContext;
import org.openecard.common.util.FileUtils;
import org.openecard.common.util.HttpRequestLineUtils;
import org.openecard.control.binding.http.common.DocumentRoot;
import org.openecard.control.binding.http.common.HeaderTypes;
import org.openecard.control.binding.http.common.Http11Response;
import org.openecard.control.binding.http.handler.CORSFilter;
import org.openecard.control.binding.http.handler.DefaultHandler;
import org.openecard.control.binding.http.handler.FileHandler;
import org.openecard.control.binding.http.handler.HttpControlHandler;
import org.openecard.control.binding.http.handler.IndexHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAppPluginActionHandler
extends HttpControlHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpAppPluginActionHandler.class);
    public static final String METHOD_HDR = "X-OeC-Method";
    private final AddonManager addonManager;
    private final AddonSelector selector;

    public HttpAppPluginActionHandler(AddonManager addonManager) {
        super("*");
        this.addonManager = addonManager;
        this.selector = new AddonSelector(addonManager);
    }

    @Override
    public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext context) throws HttpException, IOException {
        LOG.debug("HTTP request: {}", (Object)httpRequest.toString());
        CORSFilter corsFilter = new CORSFilter();
        HttpResponse corsResp = corsFilter.preProcess(httpRequest, context);
        if (corsResp != null) {
            LOG.debug("HTTP response: {}", (Object)corsResp);
            Http11Response.copyHttpResponse(corsResp, httpResponse);
            return;
        }
        String uri = httpRequest.getRequestLine().getUri();
        URI requestURI = URI.create(uri);
        String path = requestURI.getPath();
        String resourceName = path.substring(1, path.length());
        try {
            HttpResponse response;
            AppPluginAction action = this.selector.getAppPluginAction(resourceName);
            if (this.addonManager == null) {
                response = new Http11Response(500);
                StringEntity entity = new StringEntity("Addon initialization failed.", "UTF-8");
                response.setEntity(entity);
            } else {
                String rawQuery = requestURI.getRawQuery();
                HashMap<String, String> queries = new HashMap(0);
                if (rawQuery != null) {
                    queries = HttpRequestLineUtils.transform(rawQuery);
                }
                RequestBody body = null;
                if (httpRequest instanceof HttpEntityEnclosingRequest) {
                    LOG.debug("Request contains an entity.");
                    body = this.getRequestBody(httpRequest, resourceName);
                }
                Headers headers = this.readReqHeaders(httpRequest);
                headers.setHeader(METHOD_HDR, httpRequest.getRequestLine().getMethod());
                BindingResult bindingResult = action.execute(body, queries, headers, null);
                response = this.createHTTPResponseFromBindingResult(bindingResult);
            }
            response.setParams(httpRequest.getParams());
            LOG.debug("HTTP response: {}", (Object)response);
            Http11Response.copyHttpResponse(response, httpResponse);
            corsFilter.postProcess(httpRequest, httpResponse, context);
        }
        catch (AddonNotFoundException ex) {
            if (path.equals("/")) {
                new IndexHandler().handle(httpRequest, httpResponse, context);
            }
            if (path.startsWith("/")) {
                new FileHandler(new DocumentRoot("/www", "/www-files")).handle(httpRequest, httpResponse, context);
            }
            new DefaultHandler().handle(httpRequest, httpResponse, context);
        }
    }

    private Headers readReqHeaders(HttpRequest httpRequest) {
        Headers headers = new Headers();
        HeaderIterator it = httpRequest.headerIterator();
        while (it.hasNext()) {
            Header next = it.nextHeader();
            String name = next.getName();
            String value = next.getValue();
            if (this.isMultiValueHeaderType(name)) {
                for (String part : value.split(",")) {
                    headers.addHeader(name, part.trim());
                }
                continue;
            }
            headers.addHeader(name, value);
        }
        return headers;
    }

    private boolean isMultiValueHeaderType(@Nonnull String name) {
        switch (name) {
            case "Accept": 
            case "Accept-Language": 
            case "Accept-Encoding": {
                return true;
            }
        }
        return false;
    }

    private void addHTTPEntity(HttpResponse response, BindingResult bindingResult) {
        ResponseBody responseBody = bindingResult.getBody();
        if (responseBody != null && responseBody.hasValue()) {
            LOG.debug("BindingResult contains a body.");
            ContentType ct = ContentType.create(responseBody.getMimeType(), Charset.forName("UTF-8"));
            StringEntity entity = new StringEntity(responseBody.getValue(), ct);
            response.setEntity(entity);
            if (responseBody.isBase64()) {
                response.setHeader("Content-Transfer-Encoding", "Base64");
            }
        } else {
            LOG.debug("BindingResult contains no body.");
            if (bindingResult.getResultMessage() != null) {
                ContentType ct = ContentType.create("text/plain", Charset.forName("UTF-8"));
                StringEntity entity = new StringEntity(bindingResult.getResultMessage(), ct);
                response.setEntity(entity);
            }
        }
    }

    private HttpResponse createHTTPResponseFromBindingResult(BindingResult bindingResult) {
        Http11Response response;
        BindingResultCode resultCode = bindingResult.getResultCode();
        LOG.debug("Recieved BindingResult with ResultCode {}", (Object)resultCode);
        switch (resultCode) {
            case OK: {
                response = new Http11Response(200);
                break;
            }
            case REDIRECT: {
                response = new Http11Response(303);
                String location = bindingResult.getAuxResultData().get("org.openecard.addon.bind.aux_data.redirect_location");
                if (location != null && !location.isEmpty()) {
                    response.addHeader(HeaderTypes.LOCATION.fieldName(), location);
                    break;
                }
                LOG.error("No redirect address available in given BindingResult instance.");
                response = new Http11Response(500);
                break;
            }
            case WRONG_PARAMETER: 
            case MISSING_PARAMETER: {
                response = new Http11Response(400);
                break;
            }
            case INTERNAL_ERROR: {
                response = new Http11Response(500);
                break;
            }
            case RESOURCE_UNAVAILABLE: 
            case DEPENDING_HOST_UNREACHABLE: {
                response = new Http11Response(404);
                break;
            }
            case RESOURCE_LOCKED: {
                response = new Http11Response(423);
                break;
            }
            case TIMEOUT: {
                response = new Http11Response(504);
                break;
            }
            case TOO_MANY_REQUESTS: {
                response = new Http11Response(429);
                break;
            }
            default: {
                LOG.error("Untreated result code: " + (Object)((Object)resultCode));
                response = new Http11Response(500);
            }
        }
        this.addHTTPEntity(response, bindingResult);
        return response;
    }

    private RequestBody getRequestBody(HttpRequest httpRequest, String resourceName) throws IOException {
        try {
            HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)httpRequest;
            HttpEntity entity = entityRequest.getEntity();
            InputStream is = entity.getContent();
            String value = FileUtils.toString(is);
            String mimeType = ContentType.get(entity).getMimeType();
            boolean base64Content = false;
            RequestBody body = new RequestBody(resourceName, null);
            body.setValue(value, mimeType, base64Content);
            return body;
        }
        catch (UnsupportedCharsetException | ParseException e) {
            LOG.error("Failed to create request body.", e);
            return null;
        }
    }
}

