/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.handler;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.apache.http.Header;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.protocol.HttpContext;
import org.openecard.control.binding.http.common.Http11Method;
import org.openecard.control.binding.http.common.Http11Response;
import org.openecard.control.binding.http.handler.OriginsList;

public class CORSFilter {
    private static final Collection<String> NO_CORS_PATHS = new LinkedList<String>();

    public HttpResponse preProcess(HttpRequest httpRequest, HttpContext context) {
        URI origin = this.getOrigin(httpRequest);
        if (origin != null) {
            String method;
            if (this.isNoCorsPath(httpRequest.getRequestLine().getUri())) {
                Http11Response res = new Http11Response(403);
                return res;
            }
            if (!OriginsList.isValidOrigin(origin)) {
                Http11Response res = new Http11Response(403);
                return res;
            }
            if (this.isPreflight(httpRequest) && (method = this.getMethod(httpRequest)) != null) {
                Http11Response res = new Http11Response(200);
                this.postProcess(httpRequest, res, context);
                return res;
            }
        }
        return null;
    }

    public void postProcess(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext context) {
        if (this.isNoCorsPath(httpRequest.getRequestLine().getUri())) {
            return;
        }
        URI origin = this.getOrigin(httpRequest);
        if (origin != null) {
            String method;
            httpResponse.addHeader("Vary", "Origin");
            httpResponse.addHeader("Access-Control-Allow-Origin", origin.toString());
            httpResponse.addHeader("Access-Control-Allow-Credentials", "true");
            if (this.isPreflight(httpRequest) && (method = this.getMethod(httpRequest)) != null) {
                httpResponse.addHeader("Access-Control-Allow-Methods", method);
            }
        }
    }

    @Nullable
    private URI getOrigin(@Nonnull HttpRequest httpRequest) {
        try {
            Header origin = httpRequest.getFirstHeader("Origin");
            if (origin != null) {
                String origStr = origin.getValue();
                if (origStr == null) {
                    origStr = "";
                }
                return new URI(origStr);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private String getMethod(@Nonnull HttpRequest httpRequest) {
        Header acrm = httpRequest.getFirstHeader("Access-Control-Request-Method");
        String acrmStr = null;
        if (acrm != null && (acrmStr = acrm.getValue()) != null && acrmStr.isEmpty()) {
            acrmStr = null;
        }
        return acrmStr;
    }

    private boolean isNoCorsPath(String reqLineUri) {
        for (String nextPath : NO_CORS_PATHS) {
            if (!reqLineUri.startsWith(nextPath)) continue;
            return true;
        }
        return false;
    }

    private boolean isPreflight(HttpRequest req) {
        String method = req.getRequestLine().getMethod();
        return Http11Method.OPTIONS.getMethodString().equals(method);
    }

    static {
        NO_CORS_PATHS.add("/eID-Client?ShowUI");
        NO_CORS_PATHS.add("/eID-Client?tcTokenURL");
    }
}

