/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.common;

import java.util.Locale;
import org.openecard.apache.http.Header;
import org.openecard.apache.http.HeaderIterator;
import org.openecard.apache.http.HttpEntity;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.HttpVersion;
import org.openecard.apache.http.StatusLine;
import org.openecard.apache.http.message.BasicHttpResponse;
import org.openecard.control.binding.http.common.HeaderTypes;

public class Http11Response
extends BasicHttpResponse {
    public Http11Response(StatusLine statusline) {
        this(statusline.getStatusCode(), statusline.getReasonPhrase());
    }

    public Http11Response(int code, String reason) {
        super(HttpVersion.HTTP_1_1, code, reason);
    }

    public Http11Response(int code) {
        this(code, null);
    }

    public static void copyHttpResponse(HttpResponse in, HttpResponse out) {
        Locale l;
        HeaderIterator headIt = out.headerIterator();
        while (headIt.hasNext()) {
            headIt.nextHeader();
            headIt.remove();
        }
        headIt = in.headerIterator();
        while (headIt.hasNext()) {
            Header next = headIt.nextHeader();
            out.addHeader(next);
        }
        if (in.getEntity() != null) {
            HttpEntity entity = in.getEntity();
            out.setEntity(entity);
            if (entity.getContentType() != null) {
                out.setHeader(entity.getContentType());
            }
            if (entity.getContentEncoding() != null) {
                out.setHeader(entity.getContentEncoding());
            }
            if (entity.getContentLength() > 0L) {
                out.setHeader(HeaderTypes.CONTENT_LENGTH.fieldName(), Long.toString(entity.getContentLength()));
            }
        }
        if ((l = in.getLocale()) != null) {
            out.setLocale(l);
        }
        out.setStatusLine(in.getStatusLine());
    }
}

