/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openecard.addon.AddonManager;
import org.openecard.apache.http.HttpRequestInterceptor;
import org.openecard.apache.http.HttpResponseInterceptor;
import org.openecard.control.binding.http.HttpService;
import org.openecard.control.binding.http.common.DocumentRoot;
import org.openecard.control.binding.http.handler.HttpAppPluginActionHandler;
import org.openecard.control.binding.http.interceptor.CacheControlHeaderResponseInterceptor;
import org.openecard.control.binding.http.interceptor.ErrorResponseInterceptor;
import org.openecard.control.binding.http.interceptor.SecurityHeaderResponseInterceptor;
import org.openecard.control.binding.http.interceptor.ServerHeaderResponseInterceptor;
import org.openecard.control.binding.http.interceptor.StatusLineResponseInterceptor;

public class HttpBinding {
    public static final int DEFAULT_PORT = 24727;
    private final int port;
    private final DocumentRoot documentRoot;
    private List<HttpRequestInterceptor> reqInterceptors;
    private List<HttpResponseInterceptor> respInterceptors;
    private HttpService service;
    private AddonManager addonManager;

    public void setAddonManager(AddonManager addonManager) {
        this.addonManager = addonManager;
    }

    public HttpBinding() throws IOException, Exception {
        this(24727);
    }

    public HttpBinding(int port) throws IOException, Exception {
        this(port, "/www", "/www-files");
    }

    public HttpBinding(int port, String documentRootPath, String listFile) throws IOException, Exception {
        this.port = port;
        this.documentRoot = new DocumentRoot(documentRootPath, listFile);
    }

    public void setRequestInterceptors(List<HttpRequestInterceptor> reqInterceptors) {
        this.reqInterceptors = reqInterceptors;
    }

    public void setResponseInterceptors(List<HttpResponseInterceptor> respInterceptors) {
        this.respInterceptors = respInterceptors;
    }

    public void start() throws Exception {
        if (this.reqInterceptors == null) {
            this.reqInterceptors = Collections.emptyList();
        }
        if (this.respInterceptors == null) {
            this.respInterceptors = Arrays.asList(new StatusLineResponseInterceptor(), new ErrorResponseInterceptor(this.documentRoot, "/templates/error.html"), new ServerHeaderResponseInterceptor(), new SecurityHeaderResponseInterceptor(), new CacheControlHeaderResponseInterceptor());
        }
        HttpAppPluginActionHandler handler = new HttpAppPluginActionHandler(this.addonManager);
        this.service = new HttpService(this.port, handler, this.reqInterceptors, this.respInterceptors);
        this.service.start();
    }

    public void stop() throws Exception {
        if (this.service != null) {
            this.service.interrupt();
        }
    }

    public int getPort() {
        return this.service.getPort();
    }
}

