/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.security.SecureRandom;
import java.util.UUID;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.SecureRandomFactory;

public class ValueGenerators {
    private static final SecureRandom rand = SecureRandomFactory.create(32);
    private static long counter = 0L;

    private static void reseed() {
        rand.setSeed(++counter);
        rand.setSeed(System.nanoTime());
    }

    public static String generatePSK() {
        return ValueGenerators.generatePSK(64);
    }

    public static String generatePSK(int nibbleLength) {
        return ValueGenerators.generateRandomHex(nibbleLength);
    }

    public static String genBase64Session() {
        return ValueGenerators.genBase64Session(32);
    }

    public static String genBase64Session(int nibbleLength) {
        byte[] random = ValueGenerators.generateRandom(nibbleLength);
        return ByteUtils.toWebSafeBase64String(random);
    }

    public static String genHexSession() {
        return ValueGenerators.genHexSession(32);
    }

    public static String genHexSession(int nibbleLength) {
        return ValueGenerators.generateRandomHex(nibbleLength);
    }

    @Deprecated
    public static String generateSessionID() {
        return ValueGenerators.genHexSession();
    }

    @Deprecated
    public static String generateSessionID(int nibbleLength) {
        return ValueGenerators.genHexSession(nibbleLength);
    }

    public static String generateUUID() {
        String uuid = UUID.randomUUID().toString();
        return "urn:uuid:" + uuid;
    }

    public static String generateRandomHex(int nibbleLength) {
        return ByteUtils.toHexString(ValueGenerators.generateRandom(nibbleLength));
    }

    public static byte[] generateRandom(int nibbleLength) {
        if (nibbleLength < 1) {
            return null;
        }
        nibbleLength = nibbleLength / 2 + nibbleLength % 2;
        byte[] randomBytes = new byte[nibbleLength];
        ValueGenerators.reseed();
        rand.nextBytes(randomBytes);
        return randomBytes;
    }
}

