/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.BitSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UrlEncoder {
    private static final Charset ASCII = Charset.forName("ASCII");
    private static final int RADIX = 16;
    private static final BitSet ALPHA = new BitSet(256);
    private static final BitSet DIGIT = new BitSet(256);
    private static final BitSet HEX = new BitSet(256);
    private static final BitSet UNRESERVED = new BitSet(256);
    private static final BitSet RESERVED = new BitSet(256);
    private static final BitSet SUB_DELIM = new BitSet(256);
    private static final BitSet GEN_DELIM = new BitSet(256);
    private static final BitSet PCHAR = new BitSet(256);
    private static final BitSet QUERY = new BitSet(256);
    private static final BitSet FRAGMENT = new BitSet(256);
    private static final BitSet QUERY_SAFE = new BitSet(256);
    private static final BitSet FRAGMENT_SAFE = new BitSet(256);
    private final Charset charset;

    public UrlEncoder() {
        this(Charset.forName("UTF-8"));
    }

    public UrlEncoder(Charset charset) {
        this.charset = charset;
    }

    private static void setBits(BitSet bs, String chars) {
        UrlEncoder.setBitsVal(bs, chars, true);
    }

    private static void unsetBits(BitSet bs, String chars) {
        UrlEncoder.setBitsVal(bs, chars, false);
    }

    private static void setBitsVal(BitSet bs, String chars, boolean value) {
        for (byte next : chars.getBytes(ASCII)) {
            bs.set((int)next, value);
        }
    }

    public String encodeQueryParam(@Nullable String content) {
        if (content == null) {
            return null;
        }
        return this.urlEncode(content, QUERY_SAFE, false, true);
    }

    public String urlEncodeUrl(@Nullable String content) {
        if (content == null) {
            return null;
        }
        try {
            return URLEncoder.encode(content, this.charset.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Charset became invalid out of a sudden.");
        }
    }

    public String encodeFragment(@Nullable String content) {
        if (content == null) {
            return null;
        }
        return this.urlEncode(content, FRAGMENT_SAFE, false, true);
    }

    private String urlEncode(@Nonnull String content, BitSet safeChars, boolean wsPlus, boolean keepEscapes) {
        int nextVal;
        byte[] contentBytes = content.getBytes(this.charset);
        ByteArrayInputStream is = new ByteArrayInputStream(contentBytes);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((nextVal = is.read()) != -1) {
            byte b = (byte)(nextVal & 0xFF);
            if (wsPlus && b == 32) {
                os.write(43);
                continue;
            }
            if (keepEscapes && b == 37) {
                is.mark(2);
                int c1 = is.read();
                int c2 = is.read();
                if (HEX.get(c1) && HEX.get(c2)) {
                    os.write(37);
                    os.write(c1);
                    os.write(c2);
                    continue;
                }
                is.reset();
                UrlEncoder.encodeChar(os, b);
                continue;
            }
            if (safeChars.get(b)) {
                os.write(b);
                continue;
            }
            UrlEncoder.encodeChar(os, b);
        }
        return new String(os.toByteArray(), this.charset);
    }

    private static void encodeChar(ByteArrayOutputStream os, byte b) {
        os.write(37);
        char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
        char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
        os.write(hex1);
        os.write(hex2);
    }

    static {
        ALPHA.set(97, 123);
        ALPHA.set(65, 91);
        DIGIT.set(48, 58);
        HEX.or(DIGIT);
        HEX.set(97, 102);
        HEX.set(65, 70);
        UrlEncoder.setBits(SUB_DELIM, "!$&'()*+,;=");
        UrlEncoder.setBits(GEN_DELIM, ":/?#[]@");
        RESERVED.or(SUB_DELIM);
        RESERVED.or(GEN_DELIM);
        UNRESERVED.or(ALPHA);
        UNRESERVED.or(DIGIT);
        UrlEncoder.setBits(UNRESERVED, "-._~");
        PCHAR.or(UNRESERVED);
        PCHAR.or(SUB_DELIM);
        UrlEncoder.setBits(PCHAR, ":@");
        QUERY.or(PCHAR);
        UrlEncoder.setBits(QUERY, "/?");
        FRAGMENT.or(PCHAR);
        UrlEncoder.setBits(FRAGMENT, "/?");
        QUERY_SAFE.or(QUERY);
        QUERY_SAFE.andNot(RESERVED);
        FRAGMENT_SAFE.or(FRAGMENT);
        FRAGMENT_SAFE.andNot(RESERVED);
    }
}

