/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.LongUtils;

public class ShortUtils {
    public static byte[] toByteArray(short value) {
        return ShortUtils.toByteArray(value, 8);
    }

    public static byte[] toByteArray(short value, int numBits) {
        return ShortUtils.toByteArray(value, numBits, true);
    }

    public static byte[] toByteArray(short value, int numBits, boolean bigEndian) {
        byte[] result = LongUtils.toByteArray((long)value, numBits, bigEndian);
        if (result.length > 2) {
            result = ByteUtils.copy(result, result.length - 2, 2);
        }
        return result;
    }

    public static byte[] toByteArray(short value, boolean padArrayToTypeLength) {
        return ShortUtils.toByteArray(value, padArrayToTypeLength, true);
    }

    public static byte[] toByteArray(short value, boolean padArrayToTypeLength, boolean bigEndian) {
        byte[] result = ShortUtils.toByteArray(value, 8, bigEndian);
        if (padArrayToTypeLength && result.length < 2) {
            result = ByteUtils.concatenate(new byte[2 - result.length], result);
        }
        return result;
    }
}

