/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureRandomFactory {
    private static final Logger logger = LoggerFactory.getLogger(SecureRandomFactory.class);

    public static SecureRandom create(int numSeedBytes) {
        numSeedBytes = numSeedBytes < 0 ? 0 : numSeedBytes;
        SecureRandom r = "Linux".equals(System.getProperty("os.name")) ? new LinuxSecureRandom() : new SecureRandom();
        if (numSeedBytes > 0) {
            r.setSeed(r.generateSeed(numSeedBytes));
        }
        return r;
    }

    private static class UrandomSeedSource
    implements SeedSource {
        private final InputStream randomStream = new FileInputStream("/dev/urandom");

        @Override
        public byte[] genSeed(int numBytes) {
            try {
                int len;
                byte[] result = new byte[numBytes];
                int start = 0;
                for (int remaining = numBytes; remaining > 0; remaining -= len) {
                    len = this.randomStream.read(result, start, remaining);
                    if (len < 0) {
                        throw new InternalError("Entropy source /dev/urandom returned EOF.");
                    }
                    start += len;
                }
                return result;
            }
            catch (IOException ex) {
                throw new InternalError("Error while reading random numbers from /dev/urandom.\n  " + ex.getMessage());
            }
        }
    }

    private static class SecureRandomSeedSource
    implements SeedSource {
        private SecureRandomSeedSource() {
        }

        @Override
        public byte[] genSeed(int numBytes) {
            return SecureRandom.getSeed(numBytes);
        }
    }

    private static interface SeedSource {
        public byte[] genSeed(int var1);
    }

    private static class LinuxSecureRandom
    extends SecureRandom {
        private final SeedSource seedSource;

        public LinuxSecureRandom() {
            SeedSource s;
            try {
                s = new UrandomSeedSource();
            }
            catch (FileNotFoundException | SecurityException ex) {
                logger.warn("Failed to open entropy source to /dev/urandom, Falling back to default implementation.");
                s = new SecureRandomSeedSource();
            }
            this.seedSource = s;
        }

        @Override
        public byte[] generateSeed(int numBytes) {
            return this.seedSource.genSeed(numBytes);
        }
    }
}

