/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.openecard.common.interfaces.ObjectSchemaValidator;
import org.openecard.common.interfaces.ObjectValidatorException;
import org.openecard.common.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JAXBSchemaValidator
implements ObjectSchemaValidator {
    private static final Logger logger = LoggerFactory.getLogger(JAXBSchemaValidator.class);
    private final Schema schema;
    private final JAXBContext ctx;

    public static JAXBSchemaValidator load(@Nonnull Class<?> clazz, String ... schemaNames) throws IOException, SAXException, JAXBException {
        try {
            if (schemaNames == null || schemaNames.length == 0) {
                throw new IOException("No schemas given to validate the object.");
            }
            if (schemaNames.length == 1) {
                URL schemaURL = FileUtils.resolveResourceAsURL(JAXBSchemaValidator.class, schemaNames[0]);
                return new JAXBSchemaValidator(clazz, schemaURL);
            }
            StreamSource[] schemaDocuments = JAXBSchemaValidator.convertSchemaStrings2StreamSources(schemaNames);
            return new JAXBSchemaValidator(clazz, schemaDocuments);
        }
        catch (IOException ex) {
            logger.error("No schemas given for the validation or the schemas could not be found.", ex);
            throw ex;
        }
    }

    private JAXBSchemaValidator(Class<?> clazz, URL schemaURL) throws SAXException, JAXBException {
        this.schema = JAXBSchemaValidator.getSchemaFactory().newSchema(schemaURL);
        this.ctx = JAXBSchemaValidator.getJAXBContext(clazz);
    }

    private JAXBSchemaValidator(Class<?> clazz, StreamSource[] schemaDocuments) throws SAXException, JAXBException {
        this.schema = JAXBSchemaValidator.getSchemaFactory().newSchema(schemaDocuments);
        this.ctx = JAXBSchemaValidator.getJAXBContext(clazz);
    }

    @Override
    public boolean validateObject(@Nonnull Object obj) throws ObjectValidatorException {
        try {
            JAXBSource source = new JAXBSource(this.ctx, obj);
            Validator validator = this.schema.newValidator();
            validator.setErrorHandler(new CustomErrorHandler());
            validator.validate((Source)source);
            return true;
        }
        catch (SAXException ex) {
            logger.error("Validation of the input object failed.", ex);
            return false;
        }
        catch (JAXBException ex) {
            String msg = "Failed to create Source instance from given object.";
            logger.error(msg, ex);
            throw new ObjectValidatorException(msg, ex);
        }
        catch (IOException ex) {
            logger.error("No object given for validation.", ex);
            throw new ObjectValidatorException("No object given for validation.", ex);
        }
    }

    private static StreamSource[] convertSchemaStrings2StreamSources(String[] schemaNames) throws IOException {
        ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
        for (String schemaName : schemaNames) {
            StreamSource source = new StreamSource(FileUtils.resolveResourceAsStream(JAXBSchemaValidator.class, schemaName));
            sources.add(source);
        }
        return sources.toArray(new StreamSource[sources.size()]);
    }

    private static SchemaFactory getSchemaFactory() {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return sf;
    }

    private static JAXBContext getJAXBContext(Class<?> clazz) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{clazz});
        return ctx;
    }

    private class CustomErrorHandler
    implements ErrorHandler {
        private CustomErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            logger.warn(exception.getLocalizedMessage());
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

