/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class HttpRequestLineUtils {
    public static Map<String, String> transformRaw(String queryStr) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (queryStr != null) {
            String[] queries;
            for (String query : queries = queryStr.split("&")) {
                int first = query.indexOf(61);
                if (first == -1) {
                    result.put(query, "");
                    continue;
                }
                String key = query.substring(0, first);
                String value = query.substring(first + 1, query.length());
                result.put(key, value);
            }
        }
        return result;
    }

    public static Map<String, String> transform(String queryStr) throws UnsupportedEncodingException {
        return HttpRequestLineUtils.transform(queryStr, "UTF-8");
    }

    public static Map<String, String> transform(String queryStr, String encoding) throws UnsupportedEncodingException {
        Map<String, String> resultRaw = HttpRequestLineUtils.transformRaw(queryStr);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> next : resultRaw.entrySet()) {
            String k = next.getKey();
            String v = next.getValue();
            k = HttpRequestLineUtils.decodeValue(k, encoding);
            v = HttpRequestLineUtils.decodeValue(v, encoding);
            result.put(k, v);
        }
        return result;
    }

    private static String decodeValue(String v, String encoding) throws UnsupportedEncodingException {
        if (v != null) {
            v = v.replace("+", " ");
            v = URLDecoder.decode(v, encoding);
        }
        return v;
    }
}

