/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.ChannelHandleType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HandlerBuilder {
    private final byte[] contextHandle;
    private final String ifdName;
    private final BigInteger slotIdx;
    private final byte[] cardApp;
    private final byte[] slotHandle;
    private final String cardType;
    private final byte[] cardIdentifier;
    private final String protocolEndpoint;
    private final String sessionId;
    private final String binding;
    private final Boolean protectedAuthPath;

    private HandlerBuilder() {
        this(null, null, null, null, null, null, null, null, null, null, null);
    }

    private HandlerBuilder(byte[] contextHandle, String ifdName, BigInteger slotIdx, byte[] cardApp, byte[] slotHandle, String cardType, byte[] cardIdentifier, String protocolEndpoint, String sessionId, String binding, Boolean protectedAuthPath) {
        this.contextHandle = contextHandle;
        this.ifdName = ifdName;
        this.slotIdx = slotIdx;
        this.cardApp = cardApp;
        this.slotHandle = slotHandle;
        this.cardType = cardType;
        this.cardIdentifier = cardIdentifier;
        this.protocolEndpoint = protocolEndpoint;
        this.sessionId = sessionId;
        this.binding = binding;
        this.protectedAuthPath = protectedAuthPath;
    }

    public static HandlerBuilder create() {
        return new HandlerBuilder();
    }

    private <T extends CardApplicationPathType> T buildAppPath(T path) {
        path.setChannelHandle(this.buildChannelHandle());
        path.setContextHandle(this.contextHandle);
        path.setIFDName(this.ifdName);
        path.setSlotIndex(this.slotIdx);
        path.setCardApplication(this.cardApp);
        return path;
    }

    @Nonnull
    public CardApplicationPathType buildAppPath() {
        CardApplicationPathType path = this.buildAppPath(new CardApplicationPathType());
        return path;
    }

    @Nonnull
    public ConnectionHandleType buildConnectionHandle() {
        ConnectionHandleType handle = this.buildAppPath(new ConnectionHandleType());
        handle.setSlotHandle(this.slotHandle);
        handle.setRecognitionInfo(this.buildRecognitionInfo());
        if (this.protectedAuthPath != null) {
            ConnectionHandleType.SlotInfo slotInfo = new ConnectionHandleType.SlotInfo();
            slotInfo.setProtectedAuthPath(this.protectedAuthPath);
            handle.setSlotInfo(slotInfo);
        }
        return handle;
    }

    @Nullable
    public ConnectionHandleType.RecognitionInfo buildRecognitionInfo() {
        if (this.cardType != null) {
            ConnectionHandleType.RecognitionInfo rInfo = new ConnectionHandleType.RecognitionInfo();
            rInfo.setCardType(this.cardType);
            rInfo.setCardIdentifier(this.cardIdentifier);
            return rInfo;
        }
        return null;
    }

    @Nullable
    public ChannelHandleType buildChannelHandle() {
        if (this.protocolEndpoint != null || this.sessionId != null || this.binding != null) {
            ChannelHandleType chan = new ChannelHandleType();
            chan.setProtocolTerminationPoint(this.protocolEndpoint);
            chan.setSessionIdentifier(this.sessionId);
            chan.setBinding(this.binding);
            return chan;
        }
        return null;
    }

    public HandlerBuilder setContextHandle(byte[] contextHandle) {
        HandlerBuilder b = new HandlerBuilder(contextHandle, this.ifdName, this.slotIdx, this.cardApp, this.slotHandle, this.cardType, this.cardIdentifier, this.protocolEndpoint, this.sessionId, this.binding, this.protectedAuthPath);
        return b;
    }

    public HandlerBuilder setIfdName(String ifdName) {
        HandlerBuilder b = new HandlerBuilder(this.contextHandle, ifdName, this.slotIdx, this.cardApp, this.slotHandle, this.cardType, this.cardIdentifier, this.protocolEndpoint, this.sessionId, this.binding, this.protectedAuthPath);
        return b;
    }

    public HandlerBuilder setSlotIdx(BigInteger slotIdx) {
        HandlerBuilder b = new HandlerBuilder(this.contextHandle, this.ifdName, slotIdx, this.cardApp, this.slotHandle, this.cardType, this.cardIdentifier, this.protocolEndpoint, this.sessionId, this.binding, this.protectedAuthPath);
        return b;
    }

    public HandlerBuilder setCardApp(byte[] cardApp) {
        HandlerBuilder b = new HandlerBuilder(this.contextHandle, this.ifdName, this.slotIdx, cardApp, this.slotHandle, this.cardType, this.cardIdentifier, this.protocolEndpoint, this.sessionId, this.binding, this.protectedAuthPath);
        return b;
    }

    public HandlerBuilder setSlotHandle(byte[] slotHandle) {
        HandlerBuilder b = new HandlerBuilder(this.contextHandle, this.ifdName, this.slotIdx, this.cardApp, slotHandle, this.cardType, this.cardIdentifier, this.protocolEndpoint, this.sessionId, this.binding, this.protectedAuthPath);
        return b;
    }

    public HandlerBuilder setRecognitionInfo(ConnectionHandleType.RecognitionInfo info) {
        if (info != null) {
            HandlerBuilder b = new HandlerBuilder(this.contextHandle, this.ifdName, this.slotIdx, this.cardApp, this.slotHandle, info.getCardType(), info.getCardIdentifier(), this.protocolEndpoint, this.sessionId, this.binding, this.protectedAuthPath);
            return b;
        }
        return this;
    }

    public HandlerBuilder setCardType(ConnectionHandleType.RecognitionInfo info) {
        if (info != null) {
            return this.setCardType(info.getCardType());
        }
        return this;
    }

    public HandlerBuilder setCardType(String cardType) {
        HandlerBuilder b = new HandlerBuilder(this.contextHandle, this.ifdName, this.slotIdx, this.cardApp, this.slotHandle, cardType, this.cardIdentifier, this.protocolEndpoint, this.sessionId, this.binding, this.protectedAuthPath);
        return b;
    }

    public HandlerBuilder setCardIdentifier(ConnectionHandleType.RecognitionInfo info) {
        if (info != null) {
            return this.setCardIdentifier(info.getCardIdentifier());
        }
        return this;
    }

    public HandlerBuilder setCardIdentifier(byte[] cardIdentifier) {
        HandlerBuilder b = new HandlerBuilder(this.contextHandle, this.ifdName, this.slotIdx, this.cardApp, this.slotHandle, this.cardType, cardIdentifier, this.protocolEndpoint, this.sessionId, this.binding, this.protectedAuthPath);
        return b;
    }

    public HandlerBuilder setChannelHandle(ChannelHandleType channel) {
        if (channel != null) {
            HandlerBuilder b = new HandlerBuilder(this.contextHandle, this.ifdName, this.slotIdx, this.cardApp, this.slotHandle, this.cardType, this.cardIdentifier, channel.getProtocolTerminationPoint(), channel.getSessionIdentifier(), channel.getBinding(), this.protectedAuthPath);
            return b;
        }
        return this;
    }

    public HandlerBuilder setProtocolEndpoint(String protocolEndpoint) {
        HandlerBuilder b = new HandlerBuilder(this.contextHandle, this.ifdName, this.slotIdx, this.cardApp, this.slotHandle, this.cardType, this.cardIdentifier, protocolEndpoint, this.sessionId, this.binding, this.protectedAuthPath);
        return b;
    }

    public HandlerBuilder setSessionId(String sessionId) {
        HandlerBuilder b = new HandlerBuilder(this.contextHandle, this.ifdName, this.slotIdx, this.cardApp, this.slotHandle, this.cardType, this.cardIdentifier, this.protocolEndpoint, sessionId, this.binding, this.protectedAuthPath);
        return b;
    }

    public HandlerBuilder setBinding(String binding) {
        HandlerBuilder b = new HandlerBuilder(this.contextHandle, this.ifdName, this.slotIdx, this.cardApp, this.slotHandle, this.cardType, this.cardIdentifier, this.protocolEndpoint, this.sessionId, binding, this.protectedAuthPath);
        return b;
    }

    public HandlerBuilder setProtectedAuthPath(Boolean protectedAuthPath) {
        HandlerBuilder b = new HandlerBuilder(this.contextHandle, this.ifdName, this.slotIdx, this.cardApp, this.slotHandle, this.cardType, this.cardIdentifier, this.protocolEndpoint, this.sessionId, this.binding, protectedAuthPath);
        return b;
    }
}

