/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.Certificate;
import org.openecard.common.tlv.iso7816.GenericObjectValue;
import org.openecard.common.tlv.iso7816.TLVType;
import org.openecard.common.util.ByteUtils;

public class X509CertificateAttribute
extends TLVType {
    private GenericObjectValue<Certificate> value;
    private TLV subject;
    private TLV issuer;
    private Integer serialNumber;

    public X509CertificateAttribute(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv.getChild());
        this.value = new GenericObjectValue<Certificate>(p.next(0), Certificate.class);
        if (p.match(Tag.SEQUENCE_TAG)) {
            this.subject = p.next(0);
        }
        if (p.match(new Tag(TagClass.CONTEXT, false, 0L))) {
            this.issuer = p.next(0);
        }
        if (p.match(Tag.INTEGER_TAG)) {
            this.serialNumber = ByteUtils.toInteger(p.next(0).getValue());
        }
    }
}

