/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.AuthReference;
import org.openecard.common.tlv.iso7816.TLVType;

public class SecurityConditionChoice
extends TLVType {
    boolean always;
    private byte[] authIdentifier;
    private AuthReference authReference;
    private SecurityConditionChoice not;
    private List<TLV> and;
    private List<TLV> or;

    public SecurityConditionChoice(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv.getChild());
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 5L))) {
            this.always = true;
            p.next(0);
        }
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 4L))) {
            this.authIdentifier = p.next(0).getValue();
        }
        if (p.match(new Tag(TagClass.UNIVERSAL, false, 16L))) {
            try {
                this.authReference = new AuthReference(p.next(0));
            }
            catch (TLVException ex) {
                Logger.getLogger(SecurityConditionChoice.class.getName()).log(Level.SEVERE, null, ex);
                throw new TLVException("Malformed authReference");
            }
        }
        if (p.match(new Tag(TagClass.CONTEXT, false, 0L))) {
            this.not = new SecurityConditionChoice(p.next(0));
        }
        if (p.match(new Tag(TagClass.CONTEXT, false, 1L))) {
            this.and = p.next(0).asList();
        }
        if (p.match(new Tag(TagClass.CONTEXT, false, 2L))) {
            this.or = p.next(0).asList();
        }
    }

    public boolean isAlways() {
        return this.always;
    }

    public byte[] getAuthIdentifier() {
        return this.authIdentifier;
    }

    public AuthReference getAuthReference() {
        return this.authReference;
    }

    public SecurityConditionChoice getNot() {
        return this.not;
    }

    public List<TLV> getAnd() {
        return this.and;
    }

    public List<TLV> getOr() {
        return this.or;
    }
}

