/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.GenericPublicKeyObject;
import org.openecard.common.tlv.iso7816.TLVType;

public class PublicKeyChoice
extends TLVType {
    private GenericPublicKeyObject<TLV> usedKey;
    private TLV extension;
    private String usedKeyType;

    public PublicKeyChoice(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv);
        if (p.match(Tag.SEQUENCE_TAG)) {
            this.usedKeyType = "publicRSAKey";
            this.usedKey = new GenericPublicKeyObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 0L))) {
            this.usedKeyType = "publicECKey";
            this.usedKey = new GenericPublicKeyObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 1L))) {
            this.usedKeyType = "publicDHKey";
            this.usedKey = new GenericPublicKeyObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 2L))) {
            this.usedKeyType = "publicDSAKey";
            this.usedKey = new GenericPublicKeyObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 3L))) {
            this.usedKeyType = "publicKEAKey";
            this.usedKey = new GenericPublicKeyObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 4L))) {
            this.usedKeyType = "genericPublicKey";
            this.usedKey = new GenericPublicKeyObject<TLV>(p.next(0), TLV.class);
        } else {
            this.usedKeyType = "extension";
            this.extension = p.next(0);
        }
    }

    public String getElementName() {
        return this.usedKeyType;
    }

    public GenericPublicKeyObject<TLV> getElementValue() {
        return this.usedKey;
    }
}

