/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.ReferencedValue;
import org.openecard.common.tlv.iso7816.TLVType;

public class GenericObjectValue<Type>
extends TLVType {
    private ReferencedValue indirect;
    private Type direct;

    public GenericObjectValue(TLV tlv, Class<Type> clazz) throws TLVException {
        super(tlv);
        Constructor<Type> c;
        try {
            c = clazz.getConstructor(TLV.class);
        }
        catch (Exception ex) {
            throw new TLVException("Type supplied doesn't have a constructor Type(TLV).");
        }
        Parser p = new Parser(tlv);
        if (p.match(Tag.SEQUENCE_TAG) || p.match(new Tag(TagClass.UNIVERSAL, true, 19L)) || p.match(new Tag(TagClass.UNIVERSAL, true, 22L)) || p.match(new Tag(TagClass.CONTEXT, false, 3L))) {
            this.indirect = new ReferencedValue(p.next(0));
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 0L))) {
            try {
                this.direct = c.newInstance(p.next(0).getChild());
            }
            catch (InvocationTargetException ex) {
                throw new TLVException(ex);
            }
            catch (Exception ex) {
                throw new TLVException("Type supplied doesn't have a constructor Type(TLV).");
            }
        } else {
            throw new TLVException("Unexpected element in ObjectValue.");
        }
    }
}

