/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import java.io.UnsupportedEncodingException;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.iso7816.FCP;
import org.openecard.common.tlv.iso7816.FMD;

public class FCI {
    private final TLV tlv;
    private FCP fcpData;
    private FMD fmdData;

    public FCI(TLV fciTLV) throws TLVException, UnsupportedEncodingException {
        this.tlv = fciTLV;
        if (fciTLV.getTagNumWithClass() == 111L) {
            TLV child = fciTLV.getChild();
            if (child.getTagNumWithClass() == 98L) {
                this.fcpData = new FCP(child);
                child = child.getNext();
            } else {
                this.fcpData = null;
            }
            this.fmdData = child.getTagNumWithClass() == 100L ? new FMD(child) : null;
        } else if (fciTLV.getTagNumWithClass() == 98L) {
            TLV next;
            this.fcpData = new FCP(fciTLV);
            if (fciTLV.hasNext() && (next = fciTLV.getNext()).getTagNumWithClass() == 100L) {
                this.fmdData = new FMD(next);
            }
        } else if (fciTLV.getTagNumWithClass() == 100L) {
            this.fmdData = new FMD(fciTLV);
            this.fcpData = null;
        } else {
            String msg = "Unknown FCI tag discovered.";
            throw new TLVException(msg);
        }
    }

    public FCP getFCPData() {
        return this.fcpData;
    }

    public FMD getFMDData() {
        return this.fmdData;
    }
}

