/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import java.util.LinkedList;
import java.util.List;
import org.openecard.common.apdu.exception.APDUException;
import org.openecard.common.apdu.utils.CardUtils;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.iso7816.ApplicationTemplate;

public class EF_DIR {
    public static final short EF_DIR_FID = 12032;
    private final TLV tlv = new TLV();
    private List<byte[]> applicationIdentifiers;
    private List<ApplicationTemplate> applicationTemplates;

    public EF_DIR(TLV tlv) throws TLVException {
        this.tlv.setTagNumWithClass(Tag.SEQUENCE_TAG.getTagNumWithClass());
        this.tlv.setChild(tlv);
        Parser p = new Parser(this.tlv.getChild());
        this.applicationIdentifiers = new LinkedList<byte[]>();
        this.applicationTemplates = new LinkedList<ApplicationTemplate>();
        while (p.match(97L) || p.match(79L)) {
            if (p.match(97L)) {
                this.applicationTemplates.add(new ApplicationTemplate(p.next(0)));
                continue;
            }
            if (!p.match(79L)) continue;
            this.applicationIdentifiers.add(p.next(0).getValue());
        }
        if (p.next(0) != null) {
            throw new TLVException("Unrecognised element in EF.DIR.");
        }
    }

    public EF_DIR(byte[] data) throws TLVException {
        this(TLV.fromBER(data));
    }

    public static EF_DIR selectAndRead(Dispatcher dispatcher, byte[] slotHandle) throws APDUException, TLVException {
        byte[] data = CardUtils.selectReadFile(dispatcher, slotHandle, (short)12032);
        return new EF_DIR(data);
    }

    public List<byte[]> getApplicationIds() {
        return this.applicationIdentifiers;
    }

    public List<ApplicationTemplate> getApplicationTemplates() {
        return this.applicationTemplates;
    }
}

