/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.TLVType;
import org.openecard.common.util.ByteUtils;

public class CommonCertificateAttributes
extends TLVType {
    private byte[] id;
    private boolean authority = false;
    private TLV identifier;
    private TLV certHash;
    private TLV trustedUsage;
    private TLV identifiers;
    private TLV validity;

    public CommonCertificateAttributes(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv);
        if (!p.match(new Tag(TagClass.UNIVERSAL, true, 2L))) {
            throw new TLVException("Missing ID field in the CommonCertificateAttributes");
        }
        this.id = p.next(0).getValue();
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 1L))) {
            this.authority = ByteUtils.toInteger(p.next(0).getValue()) != 0;
        }
        if (p.match(Tag.SEQUENCE_TAG)) {
            this.identifier = p.next(0);
        }
        if (p.match(new Tag(TagClass.CONTEXT, false, 0L))) {
            this.certHash = p.next(0);
        }
        if (p.match(new Tag(TagClass.CONTEXT, false, 1L))) {
            this.trustedUsage = p.next(0);
        }
        if (p.match(new Tag(TagClass.CONTEXT, false, 2L))) {
            this.identifiers = p.next(0);
        }
        if (p.match(new Tag(TagClass.CONTEXT, false, 4L))) {
            this.validity = p.next(0);
        }
    }

    public byte[] getId() {
        return this.id;
    }

    public boolean isAuthority() {
        return this.authority;
    }

    public TLV getIdentifier() {
        return this.identifier;
    }

    public TLV getCertHash() {
        return this.certHash;
    }

    public TLV getTrustedUsage() {
        return this.trustedUsage;
    }

    public TLV getIdentifiers() {
        return this.identifiers;
    }

    public TLV getValidity() {
        return this.validity;
    }
}

