/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.GenericCertificateObject;
import org.openecard.common.tlv.iso7816.TLVType;
import org.openecard.common.tlv.iso7816.X509CertificateAttribute;

public class CertificateChoice
extends TLVType {
    private GenericCertificateObject<X509CertificateAttribute> x509Certificate;
    private GenericCertificateObject<TLV> x509AttributeCertificate;
    private GenericCertificateObject<TLV> spkiCertificate;
    private GenericCertificateObject<TLV> pgpCertificate;
    private GenericCertificateObject<TLV> wtlsCertificate;
    private GenericCertificateObject<TLV> x9_68Certificate;
    private GenericCertificateObject<TLV> cvCertificate;
    private GenericCertificateObject<TLV> genericCertificateObject;
    private TLV ext;

    public CertificateChoice(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv);
        if (p.match(new Tag(TagClass.UNIVERSAL, false, 16L))) {
            this.x509Certificate = new GenericCertificateObject<X509CertificateAttribute>(p.next(0), X509CertificateAttribute.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 0L))) {
            this.x509AttributeCertificate = new GenericCertificateObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 1L))) {
            this.spkiCertificate = new GenericCertificateObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 2L))) {
            this.pgpCertificate = new GenericCertificateObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 3L))) {
            this.wtlsCertificate = new GenericCertificateObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 4L))) {
            this.x9_68Certificate = new GenericCertificateObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 5L))) {
            this.cvCertificate = new GenericCertificateObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 6L))) {
            this.genericCertificateObject = new GenericCertificateObject<TLV>(p.next(0), TLV.class);
        } else {
            this.ext = p.next(0);
        }
    }

    public GenericCertificateObject<X509CertificateAttribute> getX509Certificate() {
        return this.x509Certificate;
    }

    public GenericCertificateObject<TLV> getX509AttributeCertificate() {
        return this.x509AttributeCertificate;
    }

    public GenericCertificateObject<TLV> getSpkiCertificate() {
        return this.spkiCertificate;
    }

    public GenericCertificateObject<TLV> getPgpCertificate() {
        return this.pgpCertificate;
    }

    public GenericCertificateObject<TLV> getWtlsCertificate() {
        return this.wtlsCertificate;
    }

    public GenericCertificateObject<TLV> getX9_68Certificate() {
        return this.x9_68Certificate;
    }

    public GenericCertificateObject<TLV> getCvCertificate() {
        return this.cvCertificate;
    }

    public GenericCertificateObject<TLV> getGenericCertificateObject() {
        return this.genericCertificateObject;
    }

    public TLV getExtension() {
        return this.ext;
    }
}

