/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.Path;

public class CIODDO {
    private final TLV tlv;
    private byte[] providerId;
    private Path odfPath;
    private Path ciaInfoPath;
    private byte[] applicationIdentifier;

    public CIODDO(TLV tlv) throws TLVException {
        if (tlv.getTagNumWithClass() != 115L) {
            throw new TLVException("Not of type CIODDO.");
        }
        this.tlv = tlv;
        Parser p = new Parser(tlv.getChild());
        this.providerId = null;
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 6L))) {
            this.providerId = p.next(0).getValue();
        }
        this.odfPath = null;
        if (p.match(new Tag(TagClass.UNIVERSAL, false, 16L))) {
            this.odfPath = new Path(p.next(0));
        }
        if (p.match(new Tag(TagClass.CONTEXT, false, 0L))) {
            this.ciaInfoPath = new Path(p.next(0));
        }
        if (p.match(new Tag(TagClass.APPLICATION, true, 15L))) {
            this.applicationIdentifier = p.next(0).getValue();
        }
    }

    public CIODDO(byte[] data) throws TLVException {
        this(TLV.fromBER(data));
    }

    public boolean hasProviderId() {
        return this.providerId != null;
    }

    public byte[] getProviderId() {
        return this.providerId;
    }

    public boolean hasOdfPath() {
        return this.odfPath != null;
    }

    public Path getOdfPath() {
        return this.odfPath;
    }

    public boolean hasCIAInfoPath() {
        return this.ciaInfoPath != null;
    }

    public Path getCIAInfoPath() {
        return this.ciaInfoPath;
    }

    public boolean hasApplicationIdentifier() {
        return this.applicationIdentifier != null;
    }

    public byte[] getApplicationIdentifier() {
        return this.applicationIdentifier;
    }
}

