/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.TLVBitString;
import org.openecard.common.tlv.iso7816.TLVType;
import org.openecard.common.util.ByteUtils;

public class AuthReference
extends TLVType {
    private TLVBitString authMethod;
    private Integer securityEnvironmentId;

    public AuthReference(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv.getChild());
        if (!p.match(new Tag(TagClass.UNIVERSAL, true, 3L))) {
            throw new TLVException("No auth method object in the tlv available");
        }
        this.authMethod = new TLVBitString(p.next(0));
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 2L))) {
            this.securityEnvironmentId = ByteUtils.toInteger(p.next(0).getValue());
        }
    }

    public TLVBitString getAuthMethod() {
        return this.authMethod;
    }

    public Integer getSecurityEnvironmentId() {
        return this.securityEnvironmentId;
    }
}

