/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.sal.state.cif;

import iso.std.iso_iec._24727.tech.schema.AccessRuleType;
import iso.std.iso_iec._24727.tech.schema.DIDInfoType;
import iso.std.iso_iec._24727.tech.schema.SecurityConditionType;
import java.util.HashMap;
import java.util.Map;

public class DIDInfoWrapper {
    private DIDInfoType didInfo;
    private Map<Enum<?>, SecurityConditionType> securityConditions = new HashMap();

    public DIDInfoWrapper(DIDInfoType didInfo) {
        this.didInfo = didInfo;
    }

    public DIDInfoType getDIDInfo() {
        return this.didInfo;
    }

    public SecurityConditionType getSecurityCondition(Enum<?> serviceAction) {
        if (this.securityConditions.isEmpty()) {
            for (AccessRuleType accessRule : this.didInfo.getDIDACL().getAccessRule()) {
                if (accessRule.getAction().getConnectionServiceAction() != null) {
                    this.securityConditions.put(accessRule.getAction().getConnectionServiceAction(), accessRule.getSecurityCondition());
                    continue;
                }
                if (accessRule.getAction().getAuthorizationServiceAction() != null) {
                    this.securityConditions.put(accessRule.getAction().getAuthorizationServiceAction(), accessRule.getSecurityCondition());
                    continue;
                }
                if (accessRule.getAction().getDifferentialIdentityServiceAction() != null) {
                    this.securityConditions.put(accessRule.getAction().getDifferentialIdentityServiceAction(), accessRule.getSecurityCondition());
                    continue;
                }
                if (accessRule.getAction().getNamedDataServiceAction() != null) {
                    this.securityConditions.put(accessRule.getAction().getNamedDataServiceAction(), accessRule.getSecurityCondition());
                    continue;
                }
                if (accessRule.getAction().getCryptographicServiceAction() != null) {
                    this.securityConditions.put(accessRule.getAction().getCryptographicServiceAction(), accessRule.getSecurityCondition());
                    continue;
                }
                if (accessRule.getAction().getCardApplicationServiceAction() == null) continue;
                this.securityConditions.put(accessRule.getAction().getCardApplicationServiceAction(), accessRule.getSecurityCondition());
            }
        }
        return this.securityConditions.get(serviceAction);
    }
}

