/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.sal.state;

import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationStateType;
import iso.std.iso_iec._24727.tech.schema.DIDInfoType;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.SecurityConditionType;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.openecard.addon.sal.SALProtocol;
import org.openecard.common.sal.state.cif.CardApplicationWrapper;
import org.openecard.common.sal.state.cif.CardInfoWrapper;
import org.openecard.common.sal.state.cif.DIDInfoWrapper;
import org.openecard.common.sal.state.cif.DataSetInfoWrapper;
import org.openecard.common.tlv.iso7816.FCP;
import org.openecard.common.util.ByteArrayWrapper;
import org.openecard.common.util.HandlerUtils;

public class CardStateEntry
implements Comparable<CardStateEntry> {
    private static int numberRegistry = 0;
    private final int serialNumber;
    private final Set<DIDInfoType> authenticatedDIDs = new HashSet<DIDInfoType>();
    private final ConnectionHandleType handle;
    private final CardInfoWrapper infoObject;
    private final Map<String, SALProtocol> protoObjects = new TreeMap<String, SALProtocol>();
    private FCP lastSelectedEfFCP;

    private static synchronized int nextNumber() {
        return numberRegistry++;
    }

    public CardStateEntry(ConnectionHandleType handle, CardInfoType cif, @Nullable String interfaceProtocol) {
        this(handle, new CardInfoWrapper(cif, interfaceProtocol));
    }

    private CardStateEntry(ConnectionHandleType handle, CardInfoWrapper cifWrapper) {
        this.serialNumber = CardStateEntry.nextNumber();
        this.infoObject = new CardInfoWrapper(cifWrapper);
        this.handle = handle;
        this.handle.setCardApplication(this.getImplicitlySelectedApplicationIdentifier());
    }

    public CardStateEntry derive(ConnectionHandleType handle) {
        return new CardStateEntry(handle, this.infoObject);
    }

    public String getCardType() {
        return this.infoObject.getCardType();
    }

    public void setCurrentCardApplication(byte[] currentCardApplication) {
        this.handle.setCardApplication(currentCardApplication);
    }

    public CardApplicationWrapper getCurrentCardApplication() {
        return this.infoObject.getCardApplication(this.handle.getCardApplication());
    }

    public Set<DIDInfoType> getAuthenticatedDIDs() {
        return this.authenticatedDIDs;
    }

    public void addAuthenticated(String didName, byte[] cardApplication) {
        this.authenticatedDIDs.add(this.infoObject.getDIDInfo(didName, cardApplication));
    }

    public void removeAuthenticated(DIDInfoType didInfo) {
        this.authenticatedDIDs.remove(didInfo);
    }

    public ConnectionHandleType handleCopy() {
        return HandlerUtils.copyHandle(this.handle);
    }

    public CardApplicationPathType pathCopy() {
        return HandlerUtils.copyPath(this.handle);
    }

    public boolean hasSlotIdx() {
        return this.handle.getSlotIndex() != null;
    }

    public boolean matchSlotIdx(BigInteger idx) {
        BigInteger otherIdx = this.handle.getSlotIndex();
        if (idx != null && otherIdx != null) {
            return otherIdx.equals(idx);
        }
        return false;
    }

    public String getIfdName() {
        return this.handle.getIFDName();
    }

    public CardInfoWrapper getInfo() {
        return this.infoObject;
    }

    public void setSlotHandle(byte[] slotHandle) {
        this.handle.setSlotHandle(slotHandle);
    }

    public SALProtocol setProtocol(String type, SALProtocol proto) {
        this.protoObjects.put(type, proto);
        return proto;
    }

    public SALProtocol getProtocol(String type) {
        return this.protoObjects.get(type);
    }

    public void removeProtocol(String type) {
        this.protoObjects.remove(type);
    }

    public void removeAllProtocols() {
        this.protoObjects.clear();
    }

    public void setFCPOfSelectedEF(FCP fcp) {
        this.lastSelectedEfFCP = fcp;
    }

    public void unsetFCPOfSelectedEF() {
        this.lastSelectedEfFCP = null;
    }

    public FCP getFCPOfSelectedEF() {
        return this.lastSelectedEfFCP;
    }

    public DIDStructureType getDIDStructure(String didName, byte[] cardApplication) {
        DIDStructureType didStructure = this.infoObject.getDIDStructure(didName, cardApplication);
        if (didStructure != null) {
            didStructure.setAuthenticated(this.isAuthenticated(didName, cardApplication));
        }
        return didStructure;
    }

    public DIDStructureType getDIDStructure(String didName, DIDScopeType didScope) {
        DIDStructureType didStructure = this.infoObject.getDIDStructure(didName, didScope);
        if (didStructure != null) {
            didStructure.setAuthenticated(this.isAuthenticated(didName, didScope));
        }
        return didStructure;
    }

    public boolean isAuthenticated(String didName, byte[] cardApplication) {
        DIDInfoType didInfo = this.infoObject.getDIDInfo(didName, cardApplication);
        return this.getAuthenticatedDIDs().contains(didInfo);
    }

    public boolean isAuthenticated(String didName, DIDScopeType didScope) {
        DIDInfoType didInfo = this.infoObject.getDIDInfo(didName, didScope);
        return this.getAuthenticatedDIDs().contains(didInfo);
    }

    private boolean checkSecurityCondition(SecurityConditionType securityCondition) {
        try {
            if (securityCondition.isAlways().booleanValue()) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (securityCondition.getDIDAuthentication() != null) {
            DIDAuthenticationStateType didAuthenticationState = securityCondition.getDIDAuthentication();
            byte[] cardApplication = this.getInfo().getApplicationIdByDidName(didAuthenticationState.getDIDName(), null);
            if (didAuthenticationState.isDIDState()) {
                return this.isAuthenticated(didAuthenticationState.getDIDName(), cardApplication);
            }
            return !this.isAuthenticated(didAuthenticationState.getDIDName(), cardApplication);
        }
        if (securityCondition.getOr() != null) {
            for (SecurityConditionType securityConditionOR : securityCondition.getOr().getSecurityCondition()) {
                if (!this.checkSecurityCondition(securityConditionOR)) continue;
                return true;
            }
        } else {
            if (securityCondition.getAnd() != null) {
                for (SecurityConditionType securityConditionAND : securityCondition.getAnd().getSecurityCondition()) {
                    if (this.checkSecurityCondition(securityConditionAND)) continue;
                    return false;
                }
                return true;
            }
            if (securityCondition.getNot() != null) {
                return !this.checkSecurityCondition(securityCondition.getNot());
            }
        }
        return false;
    }

    public boolean checkDIDSecurityCondition(byte[] cardApplication, String didName, Enum<?> serviceAction) {
        CardApplicationWrapper application = this.infoObject.getCardApplications().get(new ByteArrayWrapper(cardApplication));
        DIDInfoWrapper dataSetInfo = application.getDIDInfo(didName);
        SecurityConditionType securityCondition = dataSetInfo.getSecurityCondition(serviceAction);
        if (securityCondition != null) {
            return this.checkSecurityCondition(securityCondition);
        }
        return false;
    }

    public boolean checkApplicationSecurityCondition(byte[] applicationIdentifier, Enum<?> serviceAction) {
        CardApplicationWrapper application;
        SecurityConditionType securityCondition;
        if (applicationIdentifier == null) {
            applicationIdentifier = this.infoObject.getImplicitlySelectedApplication();
        }
        if ((securityCondition = (application = this.infoObject.getCardApplications().get(new ByteArrayWrapper(applicationIdentifier))).getSecurityCondition(serviceAction)) != null) {
            return this.checkSecurityCondition(securityCondition);
        }
        return false;
    }

    public boolean checkDataSetSecurityCondition(byte[] cardApplication, String dataSetName, Enum<?> serviceAction) {
        CardApplicationWrapper application = this.infoObject.getCardApplications().get(new ByteArrayWrapper(cardApplication));
        DataSetInfoWrapper dataSetInfo = application.getDataSetInfo(dataSetName);
        SecurityConditionType securityCondition = dataSetInfo.getSecurityCondition(serviceAction);
        if (securityCondition != null) {
            return this.checkSecurityCondition(securityCondition);
        }
        return false;
    }

    public final byte[] getImplicitlySelectedApplicationIdentifier() {
        return this.infoObject.getImplicitlySelectedApplication();
    }

    @Override
    public int compareTo(CardStateEntry o) {
        return this.serialNumber - o.serialNumber;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CardStateEntry) {
            CardStateEntry other = (CardStateEntry)obj;
            return this == obj || this.serialNumber == other.serialNumber;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + this.serialNumber;
        return hash;
    }
}

