/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.ifd.scio;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.openecard.common.ifd.scio.SCIOException;
import org.openecard.common.ifd.scio.SCIOTerminal;

public class TerminalState {
    private final String name;
    private final boolean cardPresent;

    public TerminalState(String name, boolean cardPresent) {
        this.name = name;
        this.cardPresent = cardPresent;
    }

    public TerminalState(SCIOTerminal term) throws SCIOException {
        this.name = term.getName();
        this.cardPresent = term.isCardPresent();
    }

    public String getName() {
        return this.name;
    }

    public boolean isCardPresent() {
        return this.cardPresent;
    }

    @Nonnull
    public static List<TerminalState> convert(@Nonnull List<SCIOTerminal> terminals) throws SCIOException {
        ArrayList<TerminalState> result = new ArrayList<TerminalState>(terminals.size());
        for (SCIOTerminal next : terminals) {
            result.add(new TerminalState(next));
        }
        return result;
    }
}

